/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum ViewType {
    CONTAINER("container"),
    LINEAR_LAYOUT("linear_layout"),
    SCROLL_LAYOUT("scroll_layout"),
    EMPTY_VIEW("empty_view"),
    WEB_VIEW("web_view"),
    MEDIA("media"),
    LABEL("label"),
    LABEL_BUTTON("label_button"),
    IMAGE_BUTTON("image_button"),
    PAGER_CONTROLLER("pager_controller"),
    PAGER("pager"),
    PAGER_INDICATOR("pager_indicator"),
    STORY_INDICATOR("story_indicator"),
    FORM_CONTROLLER("form_controller"),
    NPS_FORM_CONTROLLER("nps_form_controller"),
    CHECKBOX_CONTROLLER("checkbox_controller"),
    CHECKBOX("checkbox"),
    TOGGLE("toggle"),
    RADIO_INPUT_CONTROLLER("radio_input_controller"),
    RADIO_INPUT("radio_input"),
    TEXT_INPUT("text_input"),
    SCORE("score"),
    STATE_CONTROLLER("state_controller"),
    UNKNOWN("");

    private static final List<ViewType> FORM_INPUTS;
    private static final List<ViewType> CONTROLLERS;
    @NonNull
    private final String value;

    private ViewType(String value) {
        this.value = value;
    }

    @NonNull
    public static ViewType from(@NonNull String value) {
        for (ViewType type : ViewType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        return UNKNOWN;
    }

    @NonNull
    public static ViewType from(int ordinal) {
        for (ViewType type : ViewType.values()) {
            if (type.ordinal() != ordinal) continue;
            return type;
        }
        return UNKNOWN;
    }

    public boolean isFormInput() {
        return FORM_INPUTS.contains((Object)this);
    }

    public boolean isController() {
        return CONTROLLERS.contains((Object)this);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        FORM_INPUTS = Arrays.asList(CHECKBOX_CONTROLLER, CHECKBOX, RADIO_INPUT_CONTROLLER, RADIO_INPUT, TOGGLE, TEXT_INPUT, SCORE, FORM_CONTROLLER, NPS_FORM_CONTROLLER);
        CONTROLLERS = Arrays.asList(CHECKBOX_CONTROLLER, FORM_CONTROLLER, NPS_FORM_CONTROLLER, PAGER_CONTROLLER, RADIO_INPUT_CONTROLLER, STATE_CONTROLLER);
    }
}

