/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.reporting;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.urbanairship.Predicate;
import com.urbanairship.UALog;
import com.urbanairship.app.ActivityListener;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.app.FilteredActivityListener;
import com.urbanairship.app.SimpleActivityListener;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DisplayTimer {
    private long resumeTime = 0L;
    private long displayTime = 0L;

    public DisplayTimer(@NonNull LifecycleOwner lifecycleOwner) {
        this(lifecycleOwner, 0L);
    }

    public DisplayTimer(@NonNull LifecycleOwner lifecycleOwner, long restoredDisplayTime) {
        if (restoredDisplayTime > 0L) {
            this.displayTime = restoredDisplayTime;
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new LifecycleListener(this));
    }

    public DisplayTimer(@NonNull ActivityMonitor activityMonitor) {
        this(activityMonitor, null, 0L);
    }

    public DisplayTimer(@NonNull ActivityMonitor activityMonitor, @Nullable Predicate<Activity> activityPredicate, long restoredDisplayTime) {
        if (restoredDisplayTime > 0L) {
            this.displayTime = restoredDisplayTime;
        }
        Predicate predicate = activityPredicate != null ? activityPredicate : activity -> true;
        FilteredActivityListener activityListener2 = new FilteredActivityListener((ActivityListener)new DisplayActivityListener(this), predicate);
        activityMonitor.addActivityListener((ActivityListener)activityListener2);
    }

    public long getTime() {
        long time = this.displayTime;
        if (this.resumeTime > 0L) {
            time += System.currentTimeMillis() - this.resumeTime;
        }
        return time;
    }

    public void onResume() {
        this.resumeTime = System.currentTimeMillis();
    }

    public void onPause() {
        this.displayTime += System.currentTimeMillis() - this.resumeTime;
        this.resumeTime = 0L;
    }

    private static final class LifecycleListener
    implements DefaultLifecycleObserver {
        private final WeakReference<DisplayTimer> weakTimer;

        public LifecycleListener(DisplayTimer timer2) {
            this.weakTimer = new WeakReference<DisplayTimer>(timer2);
        }

        public void onResume(@NonNull LifecycleOwner owner) {
            DisplayTimer timer2 = (DisplayTimer)this.weakTimer.get();
            if (timer2 != null) {
                timer2.onResume();
            } else {
                UALog.w((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }

        public void onPause(@NonNull LifecycleOwner owner) {
            DisplayTimer timer2 = (DisplayTimer)this.weakTimer.get();
            if (timer2 != null) {
                timer2.onPause();
            } else {
                UALog.w((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }

        public void onDestroy(@NonNull LifecycleOwner owner) {
            owner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    private static final class DisplayActivityListener
    extends SimpleActivityListener {
        private final WeakReference<DisplayTimer> weakTimer;

        public DisplayActivityListener(DisplayTimer timer2) {
            this.weakTimer = new WeakReference<DisplayTimer>(timer2);
        }

        public void onActivityPaused(@NonNull Activity activity) {
            DisplayTimer timer2 = (DisplayTimer)this.weakTimer.get();
            if (timer2 != null) {
                timer2.onPause();
            } else {
                UALog.w((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }

        public void onActivityResumed(@NonNull Activity activity) {
            DisplayTimer timer2 = (DisplayTimer)this.weakTimer.get();
            if (timer2 != null) {
                timer2.onResume();
            } else {
                UALog.w((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }
    }
}

