/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.shape;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.shape.ShapeType;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.widget.ShapeDrawableWrapper;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Shape {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_CHECKED_STATE_SET = new int[]{-16842910, 0x10100A0};
    private static final int[] DISABLED_UNCHECKED_STATE_SET = new int[]{-16842910, -16842912};
    private static final int[] EMPTY_STATE_SET = StateSet.NOTHING;
    @NonNull
    private final ShapeType type;
    @Nullable
    private final Color color;
    @Nullable
    private final Border border;
    private final float aspectRatio;
    private final float scale;

    public Shape(@NonNull ShapeType type, float aspectRatio, float scale, @Nullable Border border, @Nullable Color color) {
        this.type = type;
        this.aspectRatio = aspectRatio;
        this.scale = scale;
        this.border = border;
        this.color = color;
    }

    @NonNull
    public static Shape fromJson(@NonNull JsonMap json) throws JsonException {
        String typeString = json.opt("type").optString();
        ShapeType type = ShapeType.from(typeString);
        float aspectRatio = json.opt("aspect_ratio").getFloat(1.0f);
        float scale = json.opt("scale").getFloat(1.0f);
        JsonMap borderJson = json.opt("border").optMap();
        Border border = Border.fromJson(borderJson);
        Color color = Color.fromJsonField(json, "color");
        return new Shape(type, aspectRatio, scale, border, color);
    }

    @NonNull
    public static StateListDrawable buildStateListDrawable(@NonNull Context context, @NonNull List<Shape> checkedShapes, @NonNull List<Shape> uncheckedShapes, @Nullable Image.Icon checkedIcon, @Nullable Image.Icon uncheckedIcon) {
        LayerDrawable checkedDrawable = Shape.buildLayerDrawable(context, checkedShapes, checkedIcon, true);
        LayerDrawable disabledCheckedDrawable = Shape.buildLayerDrawable(context, checkedShapes, checkedIcon, false);
        LayerDrawable uncheckedDrawable = Shape.buildLayerDrawable(context, uncheckedShapes, uncheckedIcon, true);
        LayerDrawable disabledUncheckedDrawable = Shape.buildLayerDrawable(context, uncheckedShapes, uncheckedIcon, false);
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(DISABLED_CHECKED_STATE_SET, (Drawable)disabledCheckedDrawable);
        drawable2.addState(DISABLED_UNCHECKED_STATE_SET, (Drawable)disabledUncheckedDrawable);
        drawable2.addState(CHECKED_STATE_SET, (Drawable)checkedDrawable);
        drawable2.addState(EMPTY_STATE_SET, (Drawable)uncheckedDrawable);
        return drawable2;
    }

    @NonNull
    private static LayerDrawable buildLayerDrawable(@NonNull Context context, @NonNull List<Shape> shapes, @Nullable Image.Icon icon, boolean enabledState) {
        int layerCount = shapes.size() + (icon != null ? 1 : 0);
        Drawable[] layers = new Drawable[layerCount];
        for (int i = 0; i < shapes.size(); ++i) {
            layers[i] = shapes.get(i).getDrawable(context, enabledState);
        }
        if (icon != null) {
            layers[layerCount - 1] = icon.getDrawable(context, enabledState);
        }
        return new LayerDrawable(layers);
    }

    @NonNull
    public Drawable getDrawable(@NonNull Context context) {
        return this.getDrawable(context, true);
    }

    @NonNull
    public Drawable getDrawable(@NonNull Context context, boolean enabledState) {
        int drawableColor = this.color != null ? this.color.resolve(context) : 0;
        int strokeWidth = this.border != null && this.border.getStrokeWidth() != null ? (int)ResourceUtils.dpToPx(context, this.border.getStrokeWidth()) : 0;
        int strokeColor = this.border != null && this.border.getStrokeColor() != null ? this.border.getStrokeColor().resolve(context) : 0;
        float radius = this.border != null && this.border.getRadius() != null ? ResourceUtils.dpToPx(context, this.border.getRadius()) : 0.0f;
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(this.type.getDrawableShapeType());
        drawable2.setColor(enabledState ? drawableColor : LayoutUtils.generateDisabledColor(drawableColor));
        drawable2.setStroke(strokeWidth, enabledState ? strokeColor : LayoutUtils.generateDisabledColor(strokeColor));
        drawable2.setCornerRadius(radius);
        return new ShapeDrawableWrapper((Drawable)drawable2, this.aspectRatio, this.scale);
    }

    @NonNull
    public ShapeType getType() {
        return this.type;
    }

    @Nullable
    public Border getBorder() {
        return this.border;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public float getScale() {
        return this.scale;
    }
}

