/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.ui;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.annotation.AnimatorRes;
import androidx.annotation.CallSuper;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.urbanairship.android.layout.BannerPresentation;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.BannerPlacement;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.property.VerticalPosition;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.util.Timer;
import com.urbanairship.android.layout.widget.ConstrainedFrameLayout;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 C2\u00020\u0001:\u0003CDEB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0002J\u0018\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0018H\u0007J\u0006\u00104\u001a\u00020/J\u0010\u00105\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020/H\u0007J\b\u0010=\u001a\u00020/H\u0007J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010?\u001a\u00020/H\u0003J\u001a\u0010@\u001a\u00020/2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rJ\u0010\u0010A\u001a\u00020/2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010B\u001a\u00020/2\u0006\u0010%\u001a\u00020&R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010!\"\u0004\b*\u0010#R$\u0010+\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#\u00a8\u0006F"}, d2={"Lcom/urbanairship/android/layout/ui/ThomasBannerView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/model/AnyModel;", "presentation", "Lcom/urbanairship/android/layout/BannerPresentation;", "environment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/BaseModel;Lcom/urbanairship/android/layout/BannerPresentation;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "animationIn", "", "animationOut", "bannerFrame", "Lcom/urbanairship/android/layout/widget/ConstrainedFrameLayout;", "displayTimer", "Lcom/urbanairship/android/layout/util/Timer;", "getDisplayTimer", "()Lcom/urbanairship/android/layout/util/Timer;", "dragHelper", "Landroidx/customview/widget/ViewDragHelper;", "isDismissed", "", "<set-?>", "isResumed", "()Z", "listener", "Lcom/urbanairship/android/layout/ui/ThomasBannerView$Listener;", "minFlingVelocity", "", "getMinFlingVelocity", "()F", "setMinFlingVelocity", "(F)V", "overDragAmount", "placement", "Lcom/urbanairship/android/layout/property/VerticalPosition;", "value", "xFraction", "getXFraction", "setXFraction", "yFraction", "getYFraction", "setYFraction", "computeScroll", "", "configureBanner", "dismiss", "animate", "isInternal", "dismissAnimated", "initDragHelper", "makeFrame", "size", "Lcom/urbanairship/android/layout/property/ConstrainedSize;", "onInterceptTouchEvent", "event", "Landroid/view/MotionEvent;", "onPause", "onResume", "onTouchEvent", "removeSelf", "setAnimations", "setListener", "setPlacement", "Companion", "Listener", "ViewDragCallback", "urbanairship-layout_release"})
public final class ThomasBannerView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseModel<?, ?> model;
    @NotNull
    private final BannerPresentation presentation;
    @NotNull
    private final ViewEnvironment environment;
    private float minFlingVelocity;
    private float overDragAmount;
    @NotNull
    private VerticalPosition placement;
    @Nullable
    private ViewDragHelper dragHelper;
    @Nullable
    private ConstrainedFrameLayout bannerFrame;
    @NotNull
    private final Timer displayTimer;
    @AnimatorRes
    private int animationIn;
    @AnimatorRes
    private int animationOut;
    private boolean isDismissed;
    private boolean isResumed;
    @Nullable
    private Listener listener;
    private static final float IDLE_MIN_DRAG_PERCENT = 0.4f;
    private static final float FLING_MIN_DRAG_PERCENT = 0.1f;
    private static final int DEFAULT_OVER_DRAG_DP = 24;

    public ThomasBannerView(@NotNull Context context, @NotNull BaseModel<?, ?> model, @NotNull BannerPresentation presentation, @NotNull ViewEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(context);
        this.model = model;
        this.presentation = presentation;
        this.environment = environment;
        this.placement = VerticalPosition.BOTTOM;
        long l = this.presentation.getDurationMs();
        this.displayTimer = new Timer(l){

            @Override
            protected void onFinish() {
                Listener listener2 = listener;
                if (listener2 != null) {
                    listener2.onTimedOut();
                }
                this.dismissAnimated();
            }
        };
        this.initDragHelper(context);
        this.setId(this.model.getViewId());
        this.configureBanner();
        this.onResume();
    }

    public final float getMinFlingVelocity() {
        return this.minFlingVelocity;
    }

    public final void setMinFlingVelocity(float f) {
        this.minFlingVelocity = f;
    }

    @NotNull
    public final Timer getDisplayTimer() {
        return this.displayTimer;
    }

    public final boolean isResumed() {
        return this.isResumed;
    }

    private final void initDragHelper(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.dragHelper = ViewDragHelper.create((ViewGroup)((ViewGroup)this), (ViewDragHelper.Callback)new ViewDragCallback());
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.minFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.overDragAmount = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private final void configureBanner() {
        BannerPlacement bannerPlacement = this.presentation.getResolvedPlacement(this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)bannerPlacement, (String)"presentation.getResolvedPlacement(context)");
        BannerPlacement placement = bannerPlacement;
        ConstrainedSize constrainedSize = placement.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)constrainedSize, (String)"placement.size");
        ConstrainedSize size = constrainedSize;
        Position position = placement.getPosition();
        Margin margin = placement.getMargin();
        ConstrainedFrameLayout frame = this.makeFrame(size);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Object containerView = this.model.createView(context, this.environment);
        frame.addView((View)containerView);
        this.addView((View)frame);
        LayoutUtils.applyBorderAndBackground((View)frame, placement.getBorder(), placement.getBackgroundColor());
        int viewId = frame.getId();
        ConstraintSetBuilder.newBuilder(this.getContext()).position(position, viewId).size(size, viewId).margin(margin, viewId).build().applyTo((ConstraintLayout)this);
        if (this.environment.isIgnoringSafeAreas()) {
            ViewCompat.setOnApplyWindowInsetsListener((View)((View)frame), ViewCompat::dispatchApplyWindowInsets);
        }
        if (this.animationIn != 0) {
            Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animationIn);
            animator2.setTarget((Object)this.bannerFrame);
            animator2.start();
        }
    }

    private final ConstrainedFrameLayout makeFrame(ConstrainedSize size) {
        ConstrainedFrameLayout constrainedFrameLayout;
        ConstrainedFrameLayout $this$makeFrame_u24lambda_u2d0 = constrainedFrameLayout = new ConstrainedFrameLayout(this.getContext(), size);
        boolean bl = false;
        $this$makeFrame_u24lambda_u2d0.setId(ConstraintLayout.generateViewId());
        $this$makeFrame_u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(0, 0));
        $this$makeFrame_u24lambda_u2d0.setElevation(ResourceUtils.dpToPx($this$makeFrame_u24lambda_u2d0.getContext(), 16));
        ConstrainedFrameLayout it = constrainedFrameLayout;
        boolean bl2 = false;
        this.bannerFrame = it;
        return constrainedFrameLayout;
    }

    @MainThread
    @CallSuper
    public final void onResume() {
        this.isResumed = true;
        if (!this.isDismissed) {
            this.displayTimer.start();
        }
    }

    @MainThread
    @CallSuper
    public final void onPause() {
        this.isResumed = false;
        this.displayTimer.stop();
    }

    public final void dismissAnimated() {
        this.dismiss(true, false);
    }

    @MainThread
    public final void dismiss(boolean animate, boolean isInternal) {
        block2: {
            block1: {
                this.isDismissed = true;
                this.displayTimer.stop();
                if (!animate || this.bannerFrame == null || this.animationOut == 0) break block1;
                this.clearAnimation();
                Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animationOut);
                animator2.setTarget((Object)this.bannerFrame);
                animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, isInternal){
                    final /* synthetic */ ThomasBannerView this$0;
                    final /* synthetic */ boolean $isInternal;
                    {
                        this.this$0 = $receiver;
                        this.$isInternal = $isInternal;
                    }

                    public void onAnimationEnd(@NotNull Animator animation) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                            ThomasBannerView.access$removeSelf(this.this$0);
                            if (this.$isInternal) break block1;
                            Listener listener2 = ThomasBannerView.access$getListener$p(this.this$0);
                            if (listener2 != null) {
                                listener2.onDismissed();
                            }
                        }
                    }
                });
                animator2.start();
                break block2;
            }
            this.removeSelf();
            if (isInternal) break block2;
            Listener listener2 = this.listener;
            if (listener2 != null) {
                listener2.onDismissed();
            }
        }
    }

    @MainThread
    private final void removeSelf() {
        block0: {
            ViewParent viewParent = this.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup == null) break block0;
            ViewGroup parent = viewGroup;
            boolean bl = false;
            parent.removeView((View)this);
            this.bannerFrame = null;
        }
    }

    public final void setAnimations(@AnimatorRes int animationIn, @AnimatorRes int animationOut) {
        this.animationIn = animationIn;
        this.animationOut = animationOut;
    }

    public final void setListener(@Nullable Listener listener2) {
        this.listener = listener2;
    }

    @Keep
    public final float getYFraction() {
        int height = this.getHeight();
        return height == 0 ? 0.0f : this.getTranslationY() / (float)height;
    }

    @Keep
    public final void setYFraction(float value) {
        if (this.getVisibility() == 0 && this.getHeight() == 0) {
            ViewTreeObserver.OnPreDrawListener preDrawListener2 = new ViewTreeObserver.OnPreDrawListener(this, value){
                final /* synthetic */ ThomasBannerView this$0;
                final /* synthetic */ float $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                }

                public boolean onPreDraw() {
                    this.this$0.setYFraction(this.$value);
                    this.this$0.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(preDrawListener2);
        } else {
            this.setTranslationY(value * (float)this.getHeight());
        }
    }

    @Keep
    public final float getXFraction() {
        int width = this.getWidth();
        return width == 0 ? 0.0f : this.getTranslationX() / (float)width;
    }

    @Keep
    public final void setXFraction(float value) {
        if (this.getVisibility() == 0 && this.getHeight() == 0) {
            ViewTreeObserver.OnPreDrawListener preDrawListener2 = new ViewTreeObserver.OnPreDrawListener(this, value){
                final /* synthetic */ ThomasBannerView this$0;
                final /* synthetic */ float $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                }

                public boolean onPreDraw() {
                    this.this$0.setXFraction(this.$value);
                    this.this$0.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(preDrawListener2);
        } else {
            this.setTranslationX(value * (float)this.getWidth());
        }
    }

    public void computeScroll() {
        super.computeScroll();
        ViewDragHelper viewDragHelper = this.dragHelper;
        boolean bl = viewDragHelper != null ? viewDragHelper.continueSettling(true) : false;
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)((View)this));
        }
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ViewDragHelper viewDragHelper = this.dragHelper;
        if (viewDragHelper == null) {
            return false;
        }
        ViewDragHelper helper = viewDragHelper;
        if (helper.shouldInterceptTouchEvent(event) || super.onInterceptTouchEvent(event)) {
            return true;
        }
        if (helper.getViewDragState() == 0 && event.getActionMasked() == 2 && helper.checkTouchSlop(2)) {
            View view = helper.findTopChildUnder((int)event.getX(), (int)event.getY());
            if (view != null) {
                View child = view;
                boolean bl = false;
                if (!child.canScrollVertically(helper.getTouchSlop())) {
                    helper.captureChildView(child, event.getPointerId(0));
                    return helper.getViewDragState() == 1;
                }
            }
        }
        return false;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        ViewDragHelper helper;
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ViewDragHelper viewDragHelper = this.dragHelper;
            if (viewDragHelper == null) {
                return false;
            }
            helper = viewDragHelper;
            helper.processTouchEvent(event);
            if (helper.getCapturedView() != null || event.getActionMasked() != 2 || !helper.checkTouchSlop(2)) break block3;
            View view = helper.findTopChildUnder((int)event.getX(), (int)event.getY());
            if (view != null) {
                View child = view;
                boolean bl = false;
                if (!child.canScrollVertically(helper.getTouchSlop())) {
                    helper.captureChildView(child, event.getPointerId(0));
                }
            }
        }
        return helper.getCapturedView() != null;
    }

    public final void setPlacement(@NotNull VerticalPosition placement) {
        Intrinsics.checkNotNullParameter((Object)((Object)placement), (String)"placement");
        this.placement = placement;
    }

    public static final /* synthetic */ void access$removeSelf(ThomasBannerView $this) {
        $this.removeSelf();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H'\u00a8\u0006\b"}, d2={"Lcom/urbanairship/android/layout/ui/ThomasBannerView$Listener;", "", "onDismissed", "", "onDragStateChanged", "state", "", "onTimedOut", "urbanairship-layout_release"})
    public static interface Listener {
        @MainThread
        public void onTimedOut();

        public void onDismissed();

        public void onDragStateChanged(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\nH\u0016J0\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/urbanairship/android/layout/ui/ThomasBannerView$ViewDragCallback;", "Landroidx/customview/widget/ViewDragHelper$Callback;", "(Lcom/urbanairship/android/layout/ui/ThomasBannerView;)V", "capturedView", "Landroid/view/View;", "dragPercent", "", "isDismissed", "", "startLeft", "", "startTop", "clampViewPositionHorizontal", "child", "left", "dx", "clampViewPositionVertical", "top", "dy", "onViewCaptured", "", "view", "activePointerId", "onViewDragStateChanged", "state", "onViewPositionChanged", "onViewReleased", "xv", "yv", "tryCaptureView", "i", "urbanairship-layout_release"})
    private final class ViewDragCallback
    extends ViewDragHelper.Callback {
        private int startTop;
        private int startLeft;
        private float dragPercent;
        @Nullable
        private View capturedView;
        private boolean isDismissed;

        public boolean tryCaptureView(@NotNull View view, int i) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return this.capturedView == null;
        }

        public int clampViewPositionHorizontal(@NotNull View child, int left, int dx) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return child.getLeft();
        }

        public int clampViewPositionVertical(@NotNull View child, int top, int dy) {
            int n;
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            switch (WhenMappings.$EnumSwitchMapping$0[ThomasBannerView.this.placement.ordinal()]) {
                case 1: {
                    n = MathKt.roundToInt((float)RangesKt.coerceAtMost((float)top, (float)((float)this.startTop + ThomasBannerView.this.overDragAmount)));
                    break;
                }
                case 2: 
                case 3: {
                    n = MathKt.roundToInt((float)RangesKt.coerceAtLeast((float)top, (float)((float)this.startTop - ThomasBannerView.this.overDragAmount)));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        public void onViewCaptured(@NotNull View view, int activePointerId) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.capturedView = view;
            this.startTop = view.getTop();
            this.startLeft = view.getLeft();
            this.dragPercent = 0.0f;
            this.isDismissed = false;
        }

        public void onViewPositionChanged(@NotNull View view, int left, int top, int dx, int dy) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int range = ThomasBannerView.this.getHeight();
            int moved = Math.abs(top - this.startTop);
            if (range > 0) {
                this.dragPercent = (float)moved / (float)range;
            }
            ThomasBannerView.this.invalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onViewDragStateChanged(int state) {
            View view = this.capturedView;
            if (view == null) {
                return;
            }
            View view2 = view;
            ThomasBannerView thomasBannerView = ThomasBannerView.this;
            ViewDragCallback viewDragCallback = this;
            synchronized (viewDragCallback) {
                boolean bl = false;
                Listener listener2 = thomasBannerView.listener;
                if (listener2 != null) {
                    listener2.onDragStateChanged(state);
                }
                if (state == 0) {
                    if (this.isDismissed) {
                        Listener listener3 = thomasBannerView.listener;
                        if (listener3 != null) {
                            listener3.onDismissed();
                        }
                        thomasBannerView.removeView(view2);
                    }
                    this.capturedView = null;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public void onViewReleased(@NotNull View view, float xv, float yv) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            float absYv = Math.abs(yv);
            if (VerticalPosition.TOP == ThomasBannerView.this.placement && this.startTop >= view.getTop() || this.startTop <= view.getTop()) {
                boolean bl = this.isDismissed = this.dragPercent >= 0.4f || absYv > ThomasBannerView.this.getMinFlingVelocity() || this.dragPercent > 0.1f;
            }
            if (this.isDismissed) {
                int top = VerticalPosition.TOP == ThomasBannerView.this.placement ? -view.getHeight() : ThomasBannerView.this.getHeight() + view.getHeight();
                ViewDragHelper viewDragHelper = ThomasBannerView.this.dragHelper;
                if (viewDragHelper != null) {
                    viewDragHelper.settleCapturedViewAt(this.startLeft, top);
                }
            } else {
                ViewDragHelper viewDragHelper = ThomasBannerView.this.dragHelper;
                if (viewDragHelper != null) {
                    viewDragHelper.settleCapturedViewAt(this.startLeft, this.startTop);
                }
            }
            ThomasBannerView.this.invalidate();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VerticalPosition.values().length];
                nArray[VerticalPosition.TOP.ordinal()] = 1;
                nArray[VerticalPosition.BOTTOM.ordinal()] = 2;
                nArray[VerticalPosition.CENTER.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/urbanairship/android/layout/ui/ThomasBannerView$Companion;", "", "()V", "DEFAULT_OVER_DRAG_DP", "", "FLING_MIN_DRAG_PERCENT", "", "IDLE_MIN_DRAG_PERCENT", "urbanairship-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

