/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.content.res.ColorStateList;
import java.util.ArrayList;
import java.util.List;

public class ColorStateListBuilder {
    private static final int[] EMPTY_STATE_SET = new int[0];
    private final List<Integer> colors = new ArrayList<Integer>();
    private final List<int[]> states = new ArrayList<int[]>();

    public ColorStateListBuilder add(int color, int ... states) {
        this.colors.add(color);
        this.states.add(states);
        return this;
    }

    public ColorStateListBuilder add(int color) {
        this.colors.add(color);
        this.states.add(EMPTY_STATE_SET);
        return this;
    }

    public ColorStateList build() {
        return new ColorStateList(this.getStates(), this.getColors());
    }

    private int[] getColors() {
        int[] array = new int[this.colors.size()];
        for (int i = 0; i < this.colors.size(); ++i) {
            array[i] = this.colors.get(i);
        }
        return array;
    }

    private int[][] getStates() {
        int[][] array = new int[this.states.size()][1];
        for (int i = 0; i < this.states.size(); ++i) {
            array[i] = this.states.get(i);
        }
        return array;
    }
}

