/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import androidx.annotation.NonNull;
import java.util.regex.Pattern;

public final class PercentUtils {
    private static final Pattern PATTERN_NON_NUMERIC = Pattern.compile("[^\\d.]");
    private static final Pattern PATTERN_PERCENT_W_SYMBOL = Pattern.compile("^\\d{1,3}%$");

    private PercentUtils() {
    }

    public static boolean isPercent(@NonNull String string) {
        return PATTERN_PERCENT_W_SYMBOL.matcher(string).matches();
    }

    public static float parse(@NonNull String percentString) {
        String number = PercentUtils.digits(percentString);
        return Float.parseFloat(number) / 100.0f;
    }

    @NonNull
    public static String digits(@NonNull String number) {
        return PATTERN_NON_NUMERIC.matcher(number).replaceAll("");
    }
}

