/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Insets;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.Orientation;
import com.urbanairship.android.layout.property.WindowSize;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    @Nullable
    public static JsonMap readJsonAsset(@NonNull Context context, @NonNull String fileName) throws JsonException, IOException {
        JsonValue jsonValue = JsonValue.parseString((String)ResourceUtils.readAsset(context, fileName));
        return jsonValue.getMap();
    }

    @NonNull
    public static List<String> listJsonAssets(@NonNull Context context, @Nullable String path) {
        String[] assets;
        AssetManager assetManager = context.getResources().getAssets();
        try {
            assets = assetManager.list(path == null ? "" : path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<String> jsonAssets = new ArrayList<String>();
        for (String a : assets) {
            if (!a.endsWith(".json")) continue;
            jsonAssets.add(a);
        }
        return jsonAssets;
    }

    @NonNull
    public static String readAsset(@NonNull Context context, @NonNull String fileName) throws IOException {
        return ResourceUtils.readStream(context.getResources().getAssets().open(fileName));
    }

    @Dimension
    public static float dpToPx(@NonNull Context context, @Dimension(unit=0) int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static boolean isUiModeNight(@NonNull Context context) {
        int mode = context.getResources().getConfiguration().uiMode & 0x30;
        return mode == 32;
    }

    @Nullable
    public static Orientation getOrientation(@NonNull Context context) {
        switch (context.getResources().getConfiguration().orientation) {
            case 1: {
                return Orientation.PORTRAIT;
            }
            case 2: {
                return Orientation.LANDSCAPE;
            }
        }
        return null;
    }

    @Nullable
    public static WindowSize getWindowSize(@NonNull Context context) {
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                return WindowSize.SMALL;
            }
            case 2: 
            case 3: {
                return WindowSize.MEDIUM;
            }
            case 4: {
                return WindowSize.LARGE;
            }
        }
        return null;
    }

    public static int getDisplayWidthPixels(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getDisplayHeightPixels(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getWindowWidthPixels(@NonNull Context context, boolean ignoreSafeArea) {
        WindowManager windowManager = ((Activity)context).getWindowManager();
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            if (ignoreSafeArea) {
                return windowMetrics.getBounds().width();
            }
            Insets insets = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            return windowMetrics.getBounds().width() - insets.left - insets.right;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getWindowHeightPixels(@NonNull Context context, boolean ignoreSafeArea) {
        WindowManager windowManager = ((Activity)context).getWindowManager();
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            if (ignoreSafeArea) {
                return windowMetrics.getBounds().height();
            }
            Insets insets = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            return windowMetrics.getBounds().height() - insets.top - insets.bottom;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    @NonNull
    private static String readStream(@NonNull InputStream inputStream) {
        try (Scanner s = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }
}

