/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;

public abstract class Timer {
    private boolean isStarted;
    private long startTimeMs;
    private long remainingTimeMs;
    private long duration;
    private long elapsedTimeMs;
    private final Handler handler = new Handler(Looper.myLooper());
    private final Runnable trigger = new Runnable(){

        @Override
        public void run() {
            if (Timer.this.isStarted) {
                Timer.this.stop();
                Timer.this.onFinish();
            }
        }
    };

    public Timer(long milliseconds) {
        this.duration = milliseconds;
        this.remainingTimeMs = milliseconds;
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.startTimeMs = SystemClock.elapsedRealtime();
        if (this.remainingTimeMs > 0L) {
            this.handler.postDelayed(this.trigger, this.remainingTimeMs);
        } else {
            this.handler.post(this.trigger);
        }
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.elapsedTimeMs += SystemClock.elapsedRealtime() - this.startTimeMs;
        this.isStarted = false;
        this.handler.removeCallbacks(this.trigger);
        this.remainingTimeMs = Math.max(0L, this.remainingTimeMs - (SystemClock.elapsedRealtime() - this.startTimeMs));
    }

    public long getRunTime() {
        if (this.isStarted) {
            return this.elapsedTimeMs + SystemClock.elapsedRealtime() - this.startTimeMs;
        }
        return this.elapsedTimeMs;
    }

    public int getProgress() {
        return (int)(this.getRunTime() * 100L / this.duration);
    }

    protected abstract void onFinish();
}

