/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.info.ImageButtonInfo;
import com.urbanairship.android.layout.info.ItemInfo;
import com.urbanairship.android.layout.info.MediaInfo;
import com.urbanairship.android.layout.info.ViewGroupInfo;
import com.urbanairship.android.layout.info.ViewInfo;
import com.urbanairship.android.layout.info.WebViewInfo;
import com.urbanairship.android.layout.property.Image;
import java.util.ArrayList;
import java.util.List;

public class UrlInfo {
    @NonNull
    private final UrlType type;
    @NonNull
    private final String url;

    UrlInfo(@NonNull UrlType type, @NonNull String url) {
        this.type = type;
        this.url = url;
    }

    @NonNull
    public UrlType getType() {
        return this.type;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public static List<UrlInfo> from(@NonNull ViewInfo info) {
        ArrayList<UrlInfo> urlInfos = new ArrayList<UrlInfo>();
        switch (info.getType()) {
            case MEDIA: {
                MediaInfo mediaInfo = (MediaInfo)info;
                switch (mediaInfo.getMediaType()) {
                    case IMAGE: {
                        urlInfos.add(new UrlInfo(UrlType.IMAGE, mediaInfo.getUrl()));
                        break;
                    }
                    case VIDEO: 
                    case YOUTUBE: {
                        urlInfos.add(new UrlInfo(UrlType.VIDEO, mediaInfo.getUrl()));
                    }
                }
                break;
            }
            case IMAGE_BUTTON: {
                ImageButtonInfo imageButtonInfo = (ImageButtonInfo)info;
                if (imageButtonInfo.getImage().getType() != Image.Type.URL) break;
                String url = ((Image.Url)imageButtonInfo.getImage()).getUrl();
                urlInfos.add(new UrlInfo(UrlType.IMAGE, url));
                break;
            }
            case WEB_VIEW: {
                WebViewInfo webViewInfo = (WebViewInfo)info;
                urlInfos.add(new UrlInfo(UrlType.WEB_PAGE, webViewInfo.getUrl()));
            }
        }
        if (info instanceof ViewGroupInfo) {
            for (ItemInfo child : ((ViewGroupInfo)info).getChildren()) {
                urlInfos.addAll(UrlInfo.from(child.getInfo()));
            }
        }
        return urlInfos;
    }

    public static enum UrlType {
        WEB_PAGE,
        IMAGE,
        VIDEO;

    }
}

