/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.animation.LayoutTransition;
import android.content.Context;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.info.ContainerLayoutItemInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ContainerLayoutModel;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ClippableConstraintLayout;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/urbanairship/android/layout/view/ContainerLayoutView;", "Lcom/urbanairship/android/layout/widget/ClippableConstraintLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/ContainerLayoutModel;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/ContainerLayoutModel;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "frameMargins", "Landroid/util/SparseArray;", "Lcom/urbanairship/android/layout/property/Margin;", "frameShouldIgnoreSafeArea", "Landroid/util/SparseBooleanArray;", "addItem", "", "constraintBuilder", "Lcom/urbanairship/android/layout/util/ConstraintSetBuilder;", "item", "Lcom/urbanairship/android/layout/model/ContainerLayoutModel$Item;", "addItems", "items", "", "WindowInsetsListener", "urbanairship-layout_release"})
public final class ContainerLayoutView
extends ClippableConstraintLayout
implements BaseView {
    @NotNull
    private final ViewEnvironment viewEnvironment;
    @NotNull
    private final SparseBooleanArray frameShouldIgnoreSafeArea;
    @NotNull
    private final SparseArray<Margin> frameMargins;

    /*
     * WARNING - void declaration
     */
    public ContainerLayoutView(@NotNull Context context, @NotNull ContainerLayoutModel model, @NotNull ViewEnvironment viewEnvironment) {
        void $this$_init__u24lambda_u2d0;
        LayoutTransition layoutTransition;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context);
        this.viewEnvironment = viewEnvironment;
        this.frameShouldIgnoreSafeArea = new SparseBooleanArray();
        this.frameMargins = new SparseArray();
        this.setClipChildren(true);
        ConstraintSetBuilder constraintSetBuilder = ConstraintSetBuilder.newBuilder(context);
        Intrinsics.checkNotNullExpressionValue((Object)constraintSetBuilder, (String)"newBuilder(context)");
        ConstraintSetBuilder constraintBuilder = constraintSetBuilder;
        this.addItems(model.getItems(), constraintBuilder);
        LayoutUtils.applyBorderAndBackground((View)this, model);
        constraintBuilder.build().applyTo((ConstraintLayout)this);
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (OnApplyWindowInsetsListener)new WindowInsetsListener(constraintBuilder));
        LayoutTransition layoutTransition2 = layoutTransition = new LayoutTransition();
        ContainerLayoutView containerLayoutView = this;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.disableTransitionType(2);
        containerLayoutView.setLayoutTransition(layoutTransition);
        model.setListener$urbanairship_layout_release((BaseModel.Listener)new BaseModel.Listener(){

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
    }

    private final void addItems(List<ContainerLayoutModel.Item> items, ConstraintSetBuilder constraintBuilder) {
        for (ContainerLayoutModel.Item item : items) {
            this.addItem(constraintBuilder, item);
        }
    }

    private final void addItem(ConstraintSetBuilder constraintBuilder, ContainerLayoutModel.Item item) {
        FrameLayout frameLayout;
        BaseModel<?, ?> baseModel = item.getModel();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Object itemView = baseModel.createView(context, this.viewEnvironment);
        int frameId = View.generateViewId();
        FrameLayout $this$addItem_u24lambda_u2d1 = frameLayout = new FrameLayout(this.getContext());
        boolean bl = false;
        $this$addItem_u24lambda_u2d1.setId(frameId);
        $this$addItem_u24lambda_u2d1.addView(itemView, -1, -1);
        ViewGroup frame = (ViewGroup)frameLayout;
        this.addView((View)frame);
        ContainerLayoutItemInfo info = item.getInfo();
        constraintBuilder.position(info.getPosition(), frameId).size(info.getSize(), frameId).margin(info.getMargin(), frameId);
        this.frameShouldIgnoreSafeArea.put(frameId, info.getIgnoreSafeArea());
        Margin margin = info.getMargin();
        if (margin == null) {
            margin = Margin.NONE;
        }
        this.frameMargins.put(frameId, (Object)margin);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/urbanairship/android/layout/view/ContainerLayoutView$WindowInsetsListener;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "constraintBuilder", "Lcom/urbanairship/android/layout/util/ConstraintSetBuilder;", "(Lcom/urbanairship/android/layout/view/ContainerLayoutView;Lcom/urbanairship/android/layout/util/ConstraintSetBuilder;)V", "onApplyWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "v", "Landroid/view/View;", "windowInsets", "urbanairship-layout_release"})
    private final class WindowInsetsListener
    implements OnApplyWindowInsetsListener {
        @NotNull
        private final ConstraintSetBuilder constraintBuilder;

        public WindowInsetsListener(ConstraintSetBuilder constraintBuilder) {
            Intrinsics.checkNotNullParameter((Object)constraintBuilder, (String)"constraintBuilder");
            this.constraintBuilder = constraintBuilder;
        }

        @NotNull
        public WindowInsetsCompat onApplyWindowInsets(@NotNull View v, @NotNull WindowInsetsCompat windowInsets) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
            WindowInsetsCompat windowInsetsCompat = ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)windowInsets);
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"onApplyWindowInsets(v, windowInsets)");
            WindowInsetsCompat applied = windowInsetsCompat;
            Insets insets = applied.getInsets(WindowInsetsCompat.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"applied.getInsets(Window\u2026Compat.Type.systemBars())");
            Insets insets2 = insets;
            if (applied.isConsumed() || Intrinsics.areEqual((Object)insets2, (Object)Insets.NONE)) {
                WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
                Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
                return windowInsetsCompat2;
            }
            boolean constraintsChanged = false;
            int n = ContainerLayoutView.this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = ContainerLayoutView.this.getChildAt(i);
                Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                ViewGroup child = (ViewGroup)view;
                boolean shouldIgnoreSafeArea = ContainerLayoutView.this.frameShouldIgnoreSafeArea.get(child.getId(), false);
                if (shouldIgnoreSafeArea) {
                    ViewCompat.dispatchApplyWindowInsets((View)((View)child), (WindowInsetsCompat)applied);
                    continue;
                }
                ViewCompat.dispatchApplyWindowInsets((View)((View)child), (WindowInsetsCompat)applied.inset(insets2));
                Margin margin = (Margin)ContainerLayoutView.this.frameMargins.get(child.getId());
                this.constraintBuilder.margin(margin, insets2, child.getId());
                constraintsChanged = true;
            }
            if (constraintsChanged) {
                this.constraintBuilder.build().applyTo((ConstraintLayout)ContainerLayoutView.this);
            }
            WindowInsetsCompat windowInsetsCompat3 = applied.inset(insets2);
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat3, (String)"applied.inset(insets)");
            return windowInsetsCompat3;
        }
    }
}

