/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.MediaModel;
import com.urbanairship.android.layout.property.MediaFit;
import com.urbanairship.android.layout.property.MediaType;
import com.urbanairship.android.layout.property.Video;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.view.MediaView;
import com.urbanairship.android.layout.view.MediaView$taps$;
import com.urbanairship.android.layout.widget.CropImageView;
import com.urbanairship.android.layout.widget.TappableView;
import com.urbanairship.android.layout.widget.TouchAwareWebView;
import com.urbanairship.app.ActivityListener;
import com.urbanairship.app.FilteredActivityListener;
import com.urbanairship.app.SimpleActivityListener;
import com.urbanairship.images.ImageRequestOptions;
import com.urbanairship.util.ManifestUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\f\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003 !\"B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0016R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/urbanairship/android/layout/view/MediaView;", "Landroid/widget/FrameLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "Lcom/urbanairship/android/layout/widget/TappableView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/MediaModel;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/MediaModel;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "activityListener", "com/urbanairship/android/layout/view/MediaView$activityListener$1", "Lcom/urbanairship/android/layout/view/MediaView$activityListener$1;", "filteredActivityListener", "Lcom/urbanairship/app/FilteredActivityListener;", "imageView", "Landroid/widget/ImageView;", "visibilityChangeListener", "Lcom/urbanairship/android/layout/view/BaseView$VisibilityChangeListener;", "webView", "Lcom/urbanairship/android/layout/widget/TouchAwareWebView;", "configureImageView", "", "configureWebView", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "", "taps", "Lkotlinx/coroutines/flow/Flow;", "Companion", "FixedAspectRatioFrameLayout", "MediaWebViewClient", "urbanairship-layout_release"})
public final class MediaView
extends FrameLayout
implements BaseView,
TappableView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewEnvironment viewEnvironment;
    @NotNull
    private final activityListener.1 activityListener;
    @NotNull
    private final FilteredActivityListener filteredActivityListener;
    @Nullable
    private BaseView.VisibilityChangeListener visibilityChangeListener;
    @Nullable
    private TouchAwareWebView webView;
    @Nullable
    private ImageView imageView;
    @Language(value="HTML")
    @NotNull
    private static final String VIDEO_HTML_FORMAT = "<body style=\"margin:0\">\n    <video id=\"video\" playsinline %s %s %s %s height=\"100%%\" width=\"100%%\" src=\"%s\"></video>\n    <script>\n        let videoElement = document.getElementById(\"video\");\n    </script>\n</body>";
    @Language(value="HTML")
    @NotNull
    private static final String IMAGE_HTML_FORMAT = "<body style=\"margin:0\">\n    <img height=\"100%%\" width=\"100%%\" src=\"%s\"/>\n</body>";
    @Language(value="HTML")
    @NotNull
    private static final String YOUTUBE_HTML_FORMAT = "<body style=\"margin:0\">\n    <!-- 1. The <iframe> (and video player) will replace this <div> tag. -->\n    <div id=\"player\"></div>\n\n    <script>\n      // 2. This code loads the IFrame Player API code asynchronously.\n      var tag = document.createElement('script');\n\n      tag.src = \"https://www.youtube.com/iframe_api\";\n      var firstScriptTag = document.getElementsByTagName('script')[0];\n      firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);\n\n      // 3. This function creates an <iframe> (and YouTube player)\n      //    after the API code downloads.\n      var player;\n      function onYouTubeIframeAPIReady() {\n        player = new YT.Player('player', {\n          height: '100%%',\n          width: '100%%',\n          videoId: '%s',\n          playerVars: {\n            'playsinline': 1,\n            'modestbranding': 1,\n            'controls': %s,\n            'autoplay': %s,\n            'mute': %s,\n            'loop': %s\n          },\n          events: {\n            'onReady': onPlayerReady\n          }\n        });\n      }\n\n      // 4. The API will call this function when the video player is ready.\n      function onPlayerReady(event) {\n        %s\n      }\n    </script>\n</body>";
    @Language(value="HTML")
    @NotNull
    private static final String YOUTUBE_AUTO_PLAYING_JS_CODE = "event.target.playVideo();\n\ndocument.addEventListener(\"visibilitychange\", () => {\n  if (document.visibilityState === \"visible\") {\n    event.target.playVideo();\n  } else {\n    event.target.pauseVideo();\n  }\n});";
    @NotNull
    private static final Regex YOUTUBE_ID_RE = new Regex("embed/([a-zA-Z0-9_-]+).*");

    public MediaView(@NotNull Context context, @NotNull MediaModel model, @NotNull ViewEnvironment viewEnvironment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context, null);
        this.viewEnvironment = viewEnvironment;
        this.activityListener = new SimpleActivityListener(this){
            final /* synthetic */ MediaView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onActivityPaused(@NotNull Activity activity) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    TouchAwareWebView touchAwareWebView = MediaView.access$getWebView$p(this.this$0);
                    if (touchAwareWebView == null) break block0;
                    touchAwareWebView.onPause();
                }
            }

            public void onActivityResumed(@NotNull Activity activity) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    TouchAwareWebView touchAwareWebView = MediaView.access$getWebView$p(this.this$0);
                    if (touchAwareWebView == null) break block0;
                    touchAwareWebView.onResume();
                }
            }
        };
        this.filteredActivityListener = new FilteredActivityListener((ActivityListener)this.activityListener, this.viewEnvironment.hostingActivityPredicate());
        LayoutUtils.applyBorderAndBackground((View)this, model);
        switch (WhenMappings.$EnumSwitchMapping$0[model.getMediaType().ordinal()]) {
            case 1: {
                this.configureImageView(model);
                break;
            }
            case 2: 
            case 3: {
                this.configureWebView(model);
            }
        }
        model.setListener$urbanairship_layout_release((BaseModel.Listener)new BaseModel.Listener(){

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
    }

    @Override
    @NotNull
    public Flow<Unit> taps() {
        Flow flow;
        Flow<MotionEvent> flow2 = this.webView;
        if (flow2 != null && (flow2 = flow2.touchEvents()) != null) {
            Flow<MotionEvent> $this$filter$iv = flow2;
            boolean $i$f$filter = false;
            Flow<MotionEvent> $this$unsafeTransform$iv$iv = $this$filter$iv;
            boolean $i$f$unsafeTransform = false;
            boolean $i$f$unsafeFlow = false;
            Flow $this$map$iv = (Flow)new Flow<MotionEvent>($this$unsafeTransform$iv$iv){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                }

                @Nullable
                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                    Continuation continuation = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u2d0 = collector;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u2d0){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        {
                            this.$this_unsafeFlow = $receiver;
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                            if (!(var2_2 instanceof taps$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                            var3_3 = var2_2;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    Object L$1;
                                    final /* synthetic */ taps$$inlined$filter$1$2 this$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit(null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var6_6 = value;
                                    $this$filter_u24lambda_u2d0 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                    (Continuation)$continuation;
                                    it = (MotionEvent)value;
                                    $i$a$-filter-MediaView$taps$1 = false;
                                    if (!ViewExtensionsKt.isActionUp(it)) break;
                                    $continuation.label = 1;
                                    v0 = $this$filter_u24lambda_u2d0.emit((Object)value, (Continuation)$continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    break;
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    break;
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
            boolean $i$f$map = false;
            Flow $this$unsafeTransform$iv$iv2 = $this$map$iv;
            boolean $i$f$unsafeTransform2 = false;
            boolean $i$f$unsafeFlow2 = false;
            flow = (Flow)new Flow<Unit>($this$unsafeTransform$iv$iv2){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                }

                @Nullable
                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                    Continuation continuation = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u2d0 = collector;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u2d0){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        {
                            this.$this_unsafeFlow = $receiver;
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                            if (!(var2_2 instanceof taps$$inlined$map$1$2$1)) ** GOTO lbl-1000
                            var3_3 = var2_2;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    final /* synthetic */ taps$$inlined$map$1$2 this$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit(null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var6_6 = value;
                                    $this$map_u24lambda_u2d4 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    var9_10 = $this$map_u24lambda_u2d4;
                                    (Continuation)$continuation;
                                    (MotionEvent)value;
                                    $i$a$-map-MediaView$taps$2 = false;
                                    $continuation.label = 1;
                                    v0 = var9_10.emit((Object)Unit.INSTANCE, (Continuation)$continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    ** GOTO lbl30
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl30:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
        } else {
            ImageView imageView = this.imageView;
            if (imageView != null) {
                flow = ViewExtensionsKt.debouncedClicks$default((View)imageView, 0L, 1, null);
            } else {
                Flow flow3;
                Flow it = flow3 = FlowKt.emptyFlow();
                boolean bl = false;
                UALog.d((String)"MediaView.clicks() was collected before child views were ready!", (Object[])new Object[0]);
                flow = flow3;
            }
        }
        return flow;
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
            super.onVisibilityChanged(changedView, visibility);
            BaseView.VisibilityChangeListener visibilityChangeListener = this.visibilityChangeListener;
            if (visibilityChangeListener == null) break block0;
            visibilityChangeListener.onVisibilityChanged(visibility);
        }
    }

    private final void configureImageView(MediaModel model) {
        Object cachedImage;
        String url = null;
        url = model.getUrl();
        String string = this.viewEnvironment.imageCache().get(url);
        if (string != null) {
            cachedImage = string;
            boolean bl = false;
            url = cachedImage;
        }
        if (StringsKt.endsWith$default((String)url, (String)".svg", (boolean)false, (int)2, null)) {
            this.configureWebView(model);
            return;
        }
        ViewGroup.LayoutParams parentLayoutParams = this.getLayoutParams();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Object $this$configureImageView_u24lambda_u2d4 = cachedImage = new CropImageView(context, null, 0, 6, null);
        boolean bl = false;
        $this$configureImageView_u24lambda_u2d4.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        $this$configureImageView_u24lambda_u2d4.setAdjustViewBounds(true);
        if (model.getMediaFit() == MediaFit.FIT_CROP) {
            ((CropImageView)((Object)$this$configureImageView_u24lambda_u2d4)).setParentLayoutParams(parentLayoutParams);
            ((CropImageView)((Object)$this$configureImageView_u24lambda_u2d4)).setImagePosition(model.getPosition());
        } else {
            $this$configureImageView_u24lambda_u2d4.setScaleType(model.getMediaFit().getScaleType());
        }
        $this$configureImageView_u24lambda_u2d4.setImportantForAccessibility(2);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((CropImageView)((Object)$this$configureImageView_u24lambda_u2d4)){
            final /* synthetic */ CropImageView $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$this_apply.setContentDescription(it);
                this.$this_apply.setImportantForAccessibility(1);
            }
        }));
        Object iv2 = cachedImage;
        this.imageView = (ImageView)iv2;
        this.addView((View)iv2);
        Ref.BooleanRef isLoaded = new Ref.BooleanRef();
        MediaView.configureImageView$loadImage(this, (CropImageView)((Object)iv2), isLoaded, url);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void configureWebView(MediaModel model) {
        FrameLayout.LayoutParams layoutParams;
        FrameLayout frameLayout;
        TouchAwareWebView wv;
        this.viewEnvironment.activityMonitor().addActivityListener((ActivityListener)this.filteredActivityListener);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.webView = wv = new TouchAwareWebView(context);
        wv.setWebChromeClient(this.viewEnvironment.webChromeClientFactory().create());
        switch (WhenMappings.$EnumSwitchMapping$0[model.getMediaType().ordinal()]) {
            case 2: 
            case 3: {
                FrameLayout.LayoutParams layoutParams2;
                FrameLayout frameLayout2;
                Context context2 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                FrameLayout $this$configureWebView_u24lambda_u2d8 = frameLayout2 = new FixedAspectRatioFrameLayout(context2);
                boolean bl = false;
                FrameLayout.LayoutParams layoutParams3 = layoutParams2 = new FrameLayout.LayoutParams(-1, -1);
                FrameLayout frameLayout3 = $this$configureWebView_u24lambda_u2d8;
                boolean bl2 = false;
                $this$configureWebView_u24lambda_u2d8_u24lambda_u2d6.gravity = 17;
                frameLayout3.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                Object object = model.getVideo();
                if (object != null && (object = ((Video)object).getAspectRatio()) != null) {
                    double it = ((Number)object).doubleValue();
                    boolean bl3 = false;
                    $this$configureWebView_u24lambda_u2d8.setAspectRatio((float)it);
                }
                frameLayout = frameLayout2;
                break;
            }
            case 1: {
                FrameLayout.LayoutParams layoutParams2;
                FrameLayout frameLayout2;
                FrameLayout $this$configureWebView_u24lambda_u2d10 = frameLayout2 = new FrameLayout(this.getContext());
                boolean bl = false;
                FrameLayout.LayoutParams $this$configureWebView_u24lambda_u2d8_u24lambda_u2d6 = layoutParams2 = new FrameLayout.LayoutParams(-1, -1);
                FrameLayout frameLayout3 = $this$configureWebView_u24lambda_u2d10;
                boolean bl4 = false;
                $this$configureWebView_u24lambda_u2d10_u24lambda_u2d9.gravity = 17;
                frameLayout3.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                frameLayout = frameLayout2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FrameLayout frameLayout4 = frameLayout;
        FrameLayout.LayoutParams $this$configureWebView_u24lambda_u2d11 = layoutParams = new FrameLayout.LayoutParams(-1, -1);
        boolean bl = false;
        $this$configureWebView_u24lambda_u2d11.gravity = 17;
        FrameLayout.LayoutParams webViewLayoutParams = layoutParams;
        frameLayout4.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLayoutParams);
        FrameLayout.LayoutParams $this$configureWebView_u24lambda_u2d12 = $this$configureWebView_u24lambda_u2d11 = new ProgressBar(this.getContext());
        boolean bl5 = false;
        $this$configureWebView_u24lambda_u2d12.setIndeterminate(true);
        $this$configureWebView_u24lambda_u2d12.setId(16908301);
        FrameLayout.LayoutParams progressBar = $this$configureWebView_u24lambda_u2d11;
        FrameLayout.LayoutParams $this$configureWebView_u24lambda_u2d13 = $this$configureWebView_u24lambda_u2d12 = new FrameLayout.LayoutParams(-2, -2);
        boolean bl6 = false;
        $this$configureWebView_u24lambda_u2d13.gravity = 17;
        FrameLayout.LayoutParams progressBarLayoutParams = $this$configureWebView_u24lambda_u2d12;
        frameLayout4.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarLayoutParams);
        FrameLayout.LayoutParams $this$configureWebView_u24lambda_u2d14 = $this$configureWebView_u24lambda_u2d12 = wv.getSettings();
        boolean bl7 = false;
        if (model.getMediaType() == MediaType.VIDEO) {
            $this$configureWebView_u24lambda_u2d14.setMediaPlaybackRequiresUserGesture(true);
        }
        $this$configureWebView_u24lambda_u2d14.setJavaScriptEnabled(true);
        if (ManifestUtils.shouldEnableLocalStorage()) {
            $this$configureWebView_u24lambda_u2d14.setDomStorageEnabled(true);
            $this$configureWebView_u24lambda_u2d14.setDatabaseEnabled(true);
        }
        WeakReference<TouchAwareWebView> webViewWeakReference = new WeakReference<TouchAwareWebView>(wv);
        Runnable load = () -> MediaView.configureWebView$lambda-18(webViewWeakReference, model);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(wv){
            final /* synthetic */ TouchAwareWebView $wv;
            {
                this.$wv = $wv;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$wv.setContentDescription(it);
            }
        }));
        wv.setVisibility(4);
        wv.setWebViewClient(new MediaWebViewClient(load, (ProgressBar)progressBar){
            final /* synthetic */ ProgressBar $progressBar;
            {
                this.$progressBar = $progressBar;
                super($load);
            }

            protected void onPageFinished(@NotNull WebView webView) {
                Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
                webView.setVisibility(0);
                this.$progressBar.setVisibility(8);
            }
        });
        this.addView((View)frameLayout4);
        load.run();
    }

    private static final void configureImageView$loadImage$lambda-5(Ref.BooleanRef $isLoaded, MediaView this$0, String $url, CropImageView $iv, boolean success) {
        Intrinsics.checkNotNullParameter((Object)$isLoaded, (String)"$isLoaded");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)((Object)$iv), (String)"$iv");
        if (success) {
            $isLoaded.element = true;
        } else {
            this$0.visibilityChangeListener = new BaseView.VisibilityChangeListener($isLoaded, $url, this$0, $iv){
                final /* synthetic */ Ref.BooleanRef $isLoaded;
                final /* synthetic */ String $url;
                final /* synthetic */ MediaView this$0;
                final /* synthetic */ CropImageView $iv;
                {
                    this.$isLoaded = $isLoaded;
                    this.$url = $url;
                    this.this$0 = $receiver;
                    this.$iv = $iv;
                }

                public void onVisibilityChanged(int visibility) {
                    if (visibility == 0 && !this.$isLoaded.element) {
                        MediaView.access$configureImageView$loadImage(this.this$0, this.$iv, this.$isLoaded, this.$url);
                    }
                }
            };
        }
    }

    private static final void configureImageView$loadImage(MediaView this$0, CropImageView iv2, Ref.BooleanRef isLoaded, String url) {
        int fallbackWidth = ResourceUtils.getDisplayWidthPixels(this$0.getContext());
        int fallbackHeight = ResourceUtils.getDisplayHeightPixels(this$0.getContext());
        ImageRequestOptions imageRequestOptions = ImageRequestOptions.newBuilder((String)url).setFallbackDimensions(fallbackWidth, fallbackHeight).setImageLoadedCallback(arg_0 -> MediaView.configureImageView$loadImage$lambda-5(isLoaded, this$0, url, iv2, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageRequestOptions, (String)"newBuilder(url)\n        \u2026\n                .build()");
        ImageRequestOptions options2 = imageRequestOptions;
        UAirship.shared().getImageLoader().load(this$0.getContext(), (ImageView)iv2, options2);
    }

    private static final void configureWebView$lambda-18(WeakReference $webViewWeakReference, MediaModel $model) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)$webViewWeakReference, (String)"$webViewWeakReference");
            Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
            TouchAwareWebView touchAwareWebView = (TouchAwareWebView)((Object)$webViewWeakReference.get());
            if (touchAwareWebView == null) break block10;
            TouchAwareWebView weakWebView = touchAwareWebView;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[$model.getMediaType().ordinal()]) {
                case 2: {
                    Video video = $model.getVideo();
                    if (video == null) {
                        video = Video.Companion.defaultVideo();
                    }
                    Video video2 = video;
                    String string = VIDEO_HTML_FORMAT;
                    Object[] objectArray = new Object[]{video2.getShowControls() ? "controls" : "", video2.getAutoplay() ? "autoplay" : "", video2.getMuted() ? "muted" : "", video2.getLoop() ? "loop" : "", $model.getUrl()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    weakWebView.loadData(string2, "text/html", "UTF-8");
                    break;
                }
                case 1: {
                    String string = IMAGE_HTML_FORMAT;
                    Object[] objectArray = new Object[]{$model.getUrl()};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    weakWebView.loadData(string3, "text/html", "UTF-8");
                    break;
                }
                case 3: {
                    Unit unit;
                    String it;
                    String videoId;
                    Video video = $model.getVideo();
                    if (video == null) {
                        video = Video.Companion.defaultVideo();
                    }
                    Video video3 = video;
                    Object object = Regex.find$default((Regex)YOUTUBE_ID_RE, (CharSequence)$model.getUrl(), (int)0, (int)2, null);
                    String string = videoId = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
                    if (string != null) {
                        it = string;
                        boolean bl2 = false;
                        String string4 = YOUTUBE_HTML_FORMAT;
                        Object[] objectArray = new Object[]{it, video3.getShowControls() ? "1" : "0", video3.getAutoplay() ? "1" : "0", video3.getMuted() ? "1" : "0", video3.getLoop() ? "1, 'playlist': '" + it + '\'' : "0", video3.getAutoplay() ? YOUTUBE_AUTO_PLAYING_JS_CODE : ""};
                        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                        weakWebView.loadData(string5, "text/html", "UTF-8");
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        it = $model.getUrl();
                        boolean bl3 = false;
                        weakWebView.loadUrl(it);
                    }
                    break;
                }
            }
        }
    }

    public static final /* synthetic */ void access$configureImageView$loadImage(MediaView this$0, CropImageView iv2, Ref.BooleanRef isLoaded, String url) {
        MediaView.configureImageView$loadImage(this$0, iv2, isLoaded, url);
    }

    public static final /* synthetic */ TouchAwareWebView access$getWebView$p(MediaView $this) {
        return $this.webView;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/urbanairship/android/layout/view/MediaView$MediaWebViewClient;", "Landroid/webkit/WebViewClient;", "onRetry", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "error", "", "getError", "()Z", "setError", "(Z)V", "retryDelay", "", "getRetryDelay", "()J", "setRetryDelay", "(J)V", "onPageFinished", "", "webView", "Landroid/webkit/WebView;", "view", "url", "", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "Landroid/webkit/WebResourceError;", "Companion", "urbanairship-layout_release"})
    private static abstract class MediaWebViewClient
    extends WebViewClient {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Runnable onRetry;
        private boolean error;
        private long retryDelay;
        private static final long START_RETRY_DELAY = 1000L;

        public MediaWebViewClient(@NotNull Runnable onRetry) {
            Intrinsics.checkNotNullParameter((Object)onRetry, (String)"onRetry");
            this.onRetry = onRetry;
            this.retryDelay = 1000L;
        }

        public final boolean getError() {
            return this.error;
        }

        public final void setError(boolean bl) {
            this.error = bl;
        }

        public final long getRetryDelay() {
            return this.retryDelay;
        }

        public final void setRetryDelay(long l) {
            this.retryDelay = l;
        }

        public void onPageFinished(@NotNull WebView view, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super.onPageFinished(view, url);
            if (this.error) {
                view.postDelayed(this.onRetry, this.retryDelay);
                this.retryDelay *= (long)2;
            } else {
                this.onPageFinished(view);
            }
            this.error = false;
        }

        public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceError error) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super.onReceivedError(view, request, error);
            this.error = true;
        }

        protected abstract void onPageFinished(@NotNull WebView var1);

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/urbanairship/android/layout/view/MediaView$MediaWebViewClient$Companion;", "", "()V", "START_RETRY_DELAY", "", "urbanairship-layout_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/urbanairship/android/layout/view/MediaView$FixedAspectRatioFrameLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "aspectRatio", "", "getAspectRatio", "()F", "setAspectRatio", "(F)V", "onMeasure", "", "widthMeasureSpec", "", "heightMeasureSpec", "urbanairship-layout_release"})
    public static final class FixedAspectRatioFrameLayout
    extends FrameLayout {
        private float aspectRatio;

        public FixedAspectRatioFrameLayout(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.aspectRatio = 1.77f;
        }

        public final float getAspectRatio() {
            return this.aspectRatio;
        }

        public final void setAspectRatio(float f) {
            this.aspectRatio = f;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            boolean bl;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int receivedWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int receivedHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int measuredWidth = 0;
            int measuredHeight = 0;
            if (heightMode == 0x40000000) {
                bl = widthMode == 0x40000000 ? receivedWidth == 0 : true;
            } else if (widthMode == 0x40000000) {
                bl = false;
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            boolean widthDynamic = bl;
            if (widthDynamic) {
                int w = (int)((float)receivedHeight * this.aspectRatio);
                measuredWidth = View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000);
                measuredHeight = heightMeasureSpec;
            } else {
                measuredWidth = widthMeasureSpec;
                int h = (int)((float)receivedWidth / this.aspectRatio);
                measuredHeight = View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000);
            }
            super.onMeasure(measuredWidth, measuredHeight);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/urbanairship/android/layout/view/MediaView$Companion;", "", "()V", "IMAGE_HTML_FORMAT", "", "VIDEO_HTML_FORMAT", "YOUTUBE_AUTO_PLAYING_JS_CODE", "YOUTUBE_HTML_FORMAT", "YOUTUBE_ID_RE", "Lkotlin/text/Regex;", "urbanairship-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            nArray[MediaType.IMAGE.ordinal()] = 1;
            nArray[MediaType.VIDEO.ordinal()] = 2;
            nArray[MediaType.YOUTUBE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

