/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.ModalPresentation;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.ModalPlacement;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.widget.ClippableFrameLayout;
import com.urbanairship.android.layout.widget.ConstrainedFrameLayout;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\rR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/urbanairship/android/layout/view/ModalView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/model/AnyModel;", "presentation", "Lcom/urbanairship/android/layout/ModalPresentation;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/BaseModel;Lcom/urbanairship/android/layout/ModalPresentation;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "clickOutsideListener", "Landroid/view/View$OnClickListener;", "containerView", "Landroid/view/View;", "modalFrame", "Lcom/urbanairship/android/layout/widget/ConstrainedFrameLayout;", "windowTouchSlop", "", "getWindowTouchSlop", "()I", "windowTouchSlop$delegate", "Lkotlin/Lazy;", "isOpaque", "", "isTouchOutside", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "setOnClickOutsideListener", "", "listener", "urbanairship-layout_release"})
public final class ModalView
extends ConstraintLayout {
    @NotNull
    private final Lazy windowTouchSlop$delegate;
    @Nullable
    private ConstrainedFrameLayout modalFrame;
    @Nullable
    private View containerView;
    @Nullable
    private View.OnClickListener clickOutsideListener;

    /*
     * WARNING - void declaration
     */
    public ModalView(@NotNull Context context, @NotNull BaseModel<?, ?> model, @NotNull ModalPresentation presentation, @NotNull ViewEnvironment viewEnvironment) {
        FrameLayout.LayoutParams layoutParams;
        ConstrainedFrameLayout frame;
        ConstrainedFrameLayout constrainedFrameLayout;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context);
        this.windowTouchSlop$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ViewConfiguration.get((Context)this.$context).getScaledWindowTouchSlop();
            }
        }));
        ModalPlacement modalPlacement = presentation.getResolvedPlacement(context);
        Intrinsics.checkNotNullExpressionValue((Object)modalPlacement, (String)"presentation.getResolvedPlacement(context)");
        ModalPlacement placement = modalPlacement;
        ConstrainedSize constrainedSize = placement.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)constrainedSize, (String)"placement.size");
        ConstrainedSize size = constrainedSize;
        Position position = placement.getPosition();
        Margin margin = placement.getMargin();
        Color color = placement.getShadeColor();
        Integer shadeColor = color != null ? Integer.valueOf(color.resolve(context)) : null;
        FrameLayout $this$_init__u24lambda_u2d0 = constrainedFrameLayout = new ConstrainedFrameLayout(context, size);
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setId(View.generateViewId());
        $this$_init__u24lambda_u2d0.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(0, 0));
        $this$_init__u24lambda_u2d0.setElevation(ResourceUtils.dpToPx(context, 16));
        this.modalFrame = frame = constrainedFrameLayout;
        FrameLayout $this$_init__u24lambda_u2d3 = $this$_init__u24lambda_u2d0 = new ClippableFrameLayout(context);
        boolean bl2 = false;
        FrameLayout.LayoutParams layoutParams2 = layoutParams = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout frameLayout = $this$_init__u24lambda_u2d3;
        boolean bl3 = false;
        Margin margin2 = margin;
        if (margin2 != null) {
            void $this$lambda_u2d3_u24lambda_u2d2;
            Margin it = margin2;
            boolean bl4 = false;
            $this$lambda_u2d3_u24lambda_u2d2.setMargins((int)ResourceUtils.dpToPx(context, it.getStart()), (int)ResourceUtils.dpToPx(context, it.getTop()), (int)ResourceUtils.dpToPx(context, it.getEnd()), (int)ResourceUtils.dpToPx(context, it.getBottom()));
        }
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        FrameLayout container = $this$_init__u24lambda_u2d0;
        container.addView((View)model.createView(context, viewEnvironment));
        LayoutUtils.applyBorderAndBackground((View)container, placement.getBorder(), placement.getBackgroundColor());
        this.containerView = (View)container;
        frame.addView((View)container);
        this.addView((View)frame);
        int viewId = frame.getId();
        ConstraintSet constraintSet = ConstraintSetBuilder.newBuilder(context).constrainWithinParent(viewId).size(size, placement.shouldIgnoreSafeArea(), viewId).position(position, viewId).build();
        Intrinsics.checkNotNullExpressionValue((Object)constraintSet, (String)"newBuilder(context)\n    \u2026wId)\n            .build()");
        ConstraintSet constraints = constraintSet;
        constraints.applyTo((ConstraintLayout)this);
        Integer n = shadeColor;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl5 = false;
            this.setBackgroundColor(it);
        }
        if (viewEnvironment.isIgnoringSafeAreas()) {
            ViewCompat.setOnApplyWindowInsetsListener((View)((View)frame), (arg_0, arg_1) -> ModalView._init_$lambda-5((ClippableFrameLayout)container, arg_0, arg_1));
        }
    }

    private final int getWindowTouchSlop() {
        Lazy lazy = this.windowTouchSlop$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                return true;
            }
            case 1: {
                if (!this.isTouchOutside(event) || this.clickOutsideListener == null) break;
                View.OnClickListener onClickListener = this.clickOutsideListener;
                if (onClickListener != null) {
                    onClickListener.onClick((View)this);
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public final void setOnClickOutsideListener(@Nullable View.OnClickListener listener2) {
        this.clickOutsideListener = listener2;
    }

    private final boolean isTouchOutside(MotionEvent event) {
        Rect r = new Rect();
        ConstrainedFrameLayout constrainedFrameLayout = this.modalFrame;
        if (constrainedFrameLayout != null) {
            constrainedFrameLayout.getHitRect(r);
        }
        r.inset(-this.getWindowTouchSlop(), -this.getWindowTouchSlop());
        return !r.contains((int)event.getX(), (int)event.getY());
    }

    private static final WindowInsetsCompat _init_$lambda-5(ClippableFrameLayout $container, View view, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)$container, (String)"$container");
        Intrinsics.checkNotNullParameter((Object)view, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        return ViewCompat.dispatchApplyWindowInsets((View)((View)$container), (WindowInsetsCompat)insets);
    }
}

