/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.urbanairship.android.layout.info.PagerIndicatorInfo;
import com.urbanairship.android.layout.model.PagerIndicatorModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ShapeView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/urbanairship/android/layout/view/PagerIndicatorView;", "Landroid/widget/LinearLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/PagerIndicatorModel;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/PagerIndicatorModel;)V", "setCount", "", "count", "", "setPosition", "position", "urbanairship-layout_release"})
public final class PagerIndicatorView
extends LinearLayout
implements BaseView {
    @NotNull
    private final PagerIndicatorModel model;

    public PagerIndicatorView(@NotNull Context context, @NotNull PagerIndicatorModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(context);
        this.model = model;
        this.setOrientation(0);
        this.setGravity(17);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.setListener$urbanairship_layout_release(new PagerIndicatorModel.Listener(){
            private boolean isInitialized;

            @Override
            public void onUpdate(int size, int position) {
                if (!this.isInitialized) {
                    this.isInitialized = true;
                    this.setCount(size);
                }
                this.setPosition(position);
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
    }

    public final void setCount(int count) {
        PagerIndicatorInfo.Bindings bindings = this.model.getBindings();
        PagerIndicatorInfo.Binding checked = bindings.getSelected();
        PagerIndicatorInfo.Binding unchecked = bindings.getUnselected();
        int spacing = (int)ResourceUtils.dpToPx(this.getContext(), this.model.getIndicatorSpacing());
        int halfSpacing = (int)((float)spacing / 2.0f);
        for (int i = 0; i < count; ++i) {
            LinearLayout.LayoutParams layoutParams;
            ShapeView shapeView;
            ShapeView $this$setCount_u24lambda_u2d0 = shapeView = new ShapeView(this.getContext(), checked.getShapes(), unchecked.getShapes(), checked.getIcon(), unchecked.getIcon());
            boolean bl = false;
            $this$setCount_u24lambda_u2d0.setId(this.model.getIndicatorViewId(i));
            $this$setCount_u24lambda_u2d0.setAdjustViewBounds(true);
            ImageView view = shapeView;
            LinearLayout.LayoutParams $this$setCount_u24lambda_u2d1 = layoutParams = new LinearLayout.LayoutParams(-2, -1);
            boolean bl2 = false;
            $this$setCount_u24lambda_u2d1.setMarginStart(i == 0 ? spacing : halfSpacing);
            $this$setCount_u24lambda_u2d1.setMarginEnd(i == count - 1 ? spacing : halfSpacing);
            LinearLayout.LayoutParams lp = layoutParams;
            this.addView((View)view, (ViewGroup.LayoutParams)lp);
        }
    }

    public final void setPosition(int position) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.Checkable");
            ((Checkable)view).setChecked(i == position);
        }
    }
}

