/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.gestures.PagerGestureDetector;
import com.urbanairship.android.layout.gestures.PagerGestureEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.view.PagerView;
import com.urbanairship.android.layout.widget.PagerRecyclerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0016\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002$%B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/urbanairship/android/layout/view/PagerView;", "Landroid/widget/FrameLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/PagerModel;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/PagerModel;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)V", "gestureDetector", "Lcom/urbanairship/android/layout/gestures/PagerGestureDetector;", "value", "Lcom/urbanairship/android/layout/view/PagerView$OnPagerGestureListener;", "gestureListener", "getGestureListener", "()Lcom/urbanairship/android/layout/view/PagerView$OnPagerGestureListener;", "setGestureListener", "(Lcom/urbanairship/android/layout/view/PagerView$OnPagerGestureListener;)V", "getModel", "()Lcom/urbanairship/android/layout/model/PagerModel;", "modelListener", "com/urbanairship/android/layout/view/PagerView$modelListener$1", "Lcom/urbanairship/android/layout/view/PagerView$modelListener$1;", "scrollListener", "Lcom/urbanairship/android/layout/view/PagerView$OnScrollListener;", "getScrollListener", "()Lcom/urbanairship/android/layout/view/PagerView$OnScrollListener;", "setScrollListener", "(Lcom/urbanairship/android/layout/view/PagerView$OnScrollListener;)V", "view", "Lcom/urbanairship/android/layout/widget/PagerRecyclerView;", "onInterceptTouchEvent", "", "event", "Landroid/view/MotionEvent;", "OnPagerGestureListener", "OnScrollListener", "urbanairship-layout_release"})
public final class PagerView
extends FrameLayout
implements BaseView {
    @NotNull
    private final PagerModel model;
    @Nullable
    private OnScrollListener scrollListener;
    @Nullable
    private OnPagerGestureListener gestureListener;
    @Nullable
    private PagerGestureDetector gestureDetector;
    @NotNull
    private final PagerRecyclerView view;
    @NotNull
    private final modelListener.1 modelListener;

    public PagerView(@NotNull Context context, @NotNull PagerModel model, @NotNull ViewEnvironment viewEnvironment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        super(context);
        this.model = model;
        this.view = new PagerRecyclerView(context, this.model, viewEnvironment);
        this.modelListener = new PagerModel.Listener(this){
            final /* synthetic */ PagerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void scrollTo(int position) {
                if (position != -1) {
                    PagerView.access$getView$p(this.this$0).scrollTo(position);
                }
            }

            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this.this$0;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            public void setEnabled(boolean enabled) {
                this.this$0.setEnabled(enabled);
            }
        };
        this.addView((View)this.view, -1, -1);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.setListener$urbanairship_layout_release((BaseModel.Listener)this.modelListener);
        this.view.setPagerScrollListener((arg_0, arg_1) -> PagerView._init_$lambda-0(this, arg_0, arg_1));
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> PagerView._init_$lambda-1(this, arg_0, arg_1));
    }

    @NotNull
    public final PagerModel getModel() {
        return this.model;
    }

    @Nullable
    public final OnScrollListener getScrollListener() {
        return this.scrollListener;
    }

    public final void setScrollListener(@Nullable OnScrollListener onScrollListener) {
        this.scrollListener = onScrollListener;
    }

    @Nullable
    public final OnPagerGestureListener getGestureListener() {
        return this.gestureListener;
    }

    public final void setGestureListener(@Nullable OnPagerGestureListener value) {
        PagerGestureDetector pagerGestureDetector;
        this.gestureListener = value;
        if (value != null) {
            pagerGestureDetector = this.gestureDetector;
            if (pagerGestureDetector == null) {
                pagerGestureDetector = new PagerGestureDetector(this, (Function1<? super PagerGestureEvent, Unit>)((Function1)new Function1<PagerGestureEvent, Unit>(this){
                    final /* synthetic */ PagerView this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull PagerGestureEvent it) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            OnPagerGestureListener onPagerGestureListener = this.this$0.getGestureListener();
                            if (onPagerGestureListener == null) break block0;
                            onPagerGestureListener.onGesture(it);
                        }
                    }
                }));
            }
        } else {
            pagerGestureDetector = null;
        }
        this.gestureDetector = pagerGestureDetector;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PagerGestureDetector pagerGestureDetector = this.gestureDetector;
            if (pagerGestureDetector == null) break block1;
            PagerGestureDetector detector = pagerGestureDetector;
            boolean bl = false;
            if (!ViewExtensionsKt.isWithinClickableDescendant(event, (View)this.view)) {
                detector.onTouchEvent(event);
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    private static final void _init_$lambda-0(PagerView this$0, int position, boolean isInternalScroll) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            OnScrollListener onScrollListener = this$0.scrollListener;
            if (onScrollListener == null) break block0;
            onScrollListener.onScrollTo(position, isInternalScroll);
        }
    }

    private static final WindowInsetsCompat _init_$lambda-1(PagerView this$0, View view, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)view, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        return ViewCompat.dispatchApplyWindowInsets((View)((View)this$0.view), (WindowInsetsCompat)insets);
    }

    public static final /* synthetic */ PagerRecyclerView access$getView$p(PagerView $this) {
        return $this.view;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/urbanairship/android/layout/view/PagerView$OnScrollListener;", "", "onScrollTo", "", "position", "", "isInternalScroll", "", "urbanairship-layout_release"})
    public static interface OnScrollListener {
        public void onScrollTo(int var1, boolean var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/urbanairship/android/layout/view/PagerView$OnPagerGestureListener;", "", "onGesture", "", "event", "Lcom/urbanairship/android/layout/gestures/PagerGestureEvent;", "urbanairship-layout_release"})
    public static interface OnPagerGestureListener {
        public void onGesture(@NotNull PagerGestureEvent var1);
    }
}

