/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.google.android.material.progressindicator.LinearProgressIndicator;
import com.urbanairship.android.layout.model.StoryIndicatorModel;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.property.StoryIndicatorSource;
import com.urbanairship.android.layout.property.StoryIndicatorStyle;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0011J&\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/urbanairship/android/layout/view/StoryIndicatorView;", "Landroid/widget/LinearLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/StoryIndicatorModel;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/StoryIndicatorModel;)V", "lastProgress", "", "progressIndicators", "", "Landroid/widget/ProgressBar;", "setCount", "", "count", "durations", "", "setProgress", "pageIndex", "progress", "animated", "", "urbanairship-layout_release"})
public final class StoryIndicatorView
extends LinearLayout
implements BaseView {
    @NotNull
    private final StoryIndicatorModel model;
    @NotNull
    private List<ProgressBar> progressIndicators;
    private int lastProgress;

    public StoryIndicatorView(@NotNull Context context, @NotNull StoryIndicatorModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(context);
        this.model = model;
        this.progressIndicators = new ArrayList();
        StoryIndicatorStyle style = this.model.getStyle();
        if (style instanceof StoryIndicatorStyle.LinearProgress) {
            this.setOrientation(((StoryIndicatorStyle.LinearProgress)style).getDirection() == Direction.VERTICAL ? 1 : 0);
            this.setGravity(17);
        }
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.setListener$urbanairship_layout_release(new StoryIndicatorModel.Listener(){
            private boolean isInitialized;

            @Override
            public void onUpdate(int size, int pageIndex, int progress, @NotNull List<Integer> durations) {
                Intrinsics.checkNotNullParameter(durations, (String)"durations");
                if (!this.isInitialized) {
                    this.isInitialized = true;
                    this.setCount(size, durations);
                }
                boolean animated = progress > lastProgress;
                lastProgress = progress;
                this.setProgress(size, pageIndex, progress, animated);
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
    }

    public final void setCount(int count, @NotNull List<Integer> durations) {
        Intrinsics.checkNotNullParameter(durations, (String)"durations");
        StoryIndicatorStyle style = this.model.getStyle();
        if (style instanceof StoryIndicatorStyle.LinearProgress) {
            int halfSpacing = (int)ResourceUtils.dpToPx(this.getContext(), ((StoryIndicatorStyle.LinearProgress)style).getSpacing() / 2);
            for (int i = 0; i < count; ++i) {
                LinearLayout.LayoutParams layoutParams;
                LinearProgressIndicator linearProgressIndicator;
                LinearProgressIndicator $this$setCount_u24lambda_u2d0 = linearProgressIndicator = new LinearProgressIndicator(this.getContext());
                boolean bl = false;
                $this$setCount_u24lambda_u2d0.setId(this.model.getIndicatorViewId(i));
                $this$setCount_u24lambda_u2d0.setMax(100);
                int[] nArray = new int[]{((StoryIndicatorStyle.LinearProgress)style).getProgressColor().resolve($this$setCount_u24lambda_u2d0.getContext())};
                $this$setCount_u24lambda_u2d0.setIndicatorColor(nArray);
                $this$setCount_u24lambda_u2d0.setTrackColor(((StoryIndicatorStyle.LinearProgress)style).getTrackColor().resolve($this$setCount_u24lambda_u2d0.getContext()));
                $this$setCount_u24lambda_u2d0.setIndicatorDirection(2);
                $this$setCount_u24lambda_u2d0.setIndeterminate(false);
                LinearProgressIndicator progressIndicator = linearProgressIndicator;
                LinearLayout.LayoutParams $this$setCount_u24lambda_u2d1 = layoutParams = new LinearLayout.LayoutParams(-2, -1);
                boolean bl2 = false;
                $this$setCount_u24lambda_u2d1.setMarginStart(i == 0 ? 0 : halfSpacing);
                $this$setCount_u24lambda_u2d1.setMarginEnd(i == count - 1 ? 0 : halfSpacing);
                LinearLayout.LayoutParams lp = layoutParams;
                StoryIndicatorStyle.LinearProgress.SizingType sizingType = ((StoryIndicatorStyle.LinearProgress)style).getSizing();
                switch (sizingType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sizingType.ordinal()]) {
                    case -1: 
                    case 1: {
                        LinearLayout.LayoutParams layoutParams2;
                        LinearLayout.LayoutParams $this$setCount_u24lambda_u2d2 = layoutParams2 = lp;
                        boolean bl3 = false;
                        $this$setCount_u24lambda_u2d2.weight = 1.0f;
                        break;
                    }
                    case 2: {
                        Unit unit;
                        LinearLayout.LayoutParams layoutParams3;
                        LinearLayout.LayoutParams $this$setCount_u24lambda_u2d5 = layoutParams3 = lp;
                        boolean bl4 = false;
                        Integer n = durations.get(i);
                        if (n != null) {
                            int it = ((Number)n).intValue();
                            boolean bl5 = false;
                            $this$setCount_u24lambda_u2d5.weight = it;
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) break;
                        LinearLayout.LayoutParams $this$setCount_u24lambda_u2d5_u24lambda_u2d4 = $this$setCount_u24lambda_u2d5;
                        boolean bl6 = false;
                        progressIndicator.setVisibility(8);
                        break;
                    }
                }
                this.addView((View)progressIndicator, (ViewGroup.LayoutParams)lp);
                this.progressIndicators.add((ProgressBar)progressIndicator);
            }
        }
    }

    public final void setProgress(int count, int pageIndex, int progress, boolean animated) {
        if (this.progressIndicators.isEmpty() || this.progressIndicators.size() <= pageIndex) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            LinearProgressIndicator it;
            ProgressBar progressBar = this.progressIndicators.get(i);
            if ((progressBar instanceof LinearProgressIndicator ? (LinearProgressIndicator)progressBar : null) == null) continue;
            it = it;
            boolean bl = false;
            if (i == pageIndex) {
                if (this.model.getSource() == StoryIndicatorSource.CURRENT_PAGE) {
                    it.setVisibility(0);
                }
                it.setProgressCompat(progress, animated);
                continue;
            }
            if (this.model.getSource() == StoryIndicatorSource.CURRENT_PAGE) {
                it.setVisibility(8);
            }
            if (i > pageIndex) {
                it.setProgressCompat(0, false);
                continue;
            }
            it.setProgressCompat(100, false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StoryIndicatorStyle.LinearProgress.SizingType.values().length];
            nArray[StoryIndicatorStyle.LinearProgress.SizingType.EQUAL.ordinal()] = 1;
            nArray[StoryIndicatorStyle.LinearProgress.SizingType.PAGE_DURATION.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

