/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.appcompat.widget.AppCompatEditText;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.TextInputModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.TappableView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/urbanairship/android/layout/view/TextInputView;", "Landroidx/appcompat/widget/AppCompatEditText;", "Lcom/urbanairship/android/layout/view/BaseView;", "Lcom/urbanairship/android/layout/widget/TappableView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/TextInputModel;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/TextInputModel;)V", "clicksChannel", "Lkotlinx/coroutines/channels/Channel;", "", "touchListener", "Landroid/view/View$OnTouchListener;", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "taps", "Lkotlinx/coroutines/flow/Flow;", "urbanairship-layout_release"})
public final class TextInputView
extends AppCompatEditText
implements BaseView,
TappableView {
    @NotNull
    private final Channel<Unit> clicksChannel;
    @NotNull
    private final View.OnTouchListener touchListener;

    public TextInputView(@NotNull Context context, @NotNull TextInputModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(context);
        this.clicksChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.touchListener = (arg_0, arg_1) -> TextInputView.touchListener$lambda-0(this, arg_0, arg_1);
        this.setBackground(null);
        this.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        LayoutUtils.applyTextInputModel(this, model);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.setContentDescription(it);
            }
        }));
        model.setListener$urbanairship_layout_release((BaseModel.Listener)new TextInputModel.Listener(){

            @Override
            public void restoreValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                CharSequence charSequence = (CharSequence)this.getText();
                if (charSequence == null || charSequence.length() == 0) {
                    this.setText(value);
                }
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }
        });
        this.setOnTouchListener(this.touchListener);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        outAttrs.imeOptions |= 0x12000000;
        return super.onCreateInputConnection(outAttrs);
    }

    @Override
    @NotNull
    public Flow<Unit> taps() {
        return FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.clicksChannel));
    }

    private static final boolean touchListener$lambda-0(TextInputView this$0, View v, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        v.getParent().requestDisallowInterceptTouchEvent(true);
        if (ViewExtensionsKt.isActionUp(event)) {
            v.getParent().requestDisallowInterceptTouchEvent(false);
            this$0.clicksChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }
        return false;
    }
}

