/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import androidx.appcompat.widget.AppCompatImageView;
import com.urbanairship.android.layout.property.HorizontalPosition;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.android.layout.property.VerticalPosition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J\u0012\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/urbanairship/android/layout/widget/CropImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "offsetHorizontal", "", "offsetVertical", "parentHeightSpec", "parentWidthSpec", "applyCropOffset", "", "onSizeChanged", "w", "h", "oldw", "oldh", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImagePosition", "position", "Lcom/urbanairship/android/layout/property/Position;", "setParentLayoutParams", "layoutParams", "Landroid/view/ViewGroup$LayoutParams;", "Companion", "urbanairship-layout_release"})
public final class CropImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float offsetHorizontal;
    private float offsetVertical;
    private int parentWidthSpec;
    private int parentHeightSpec;
    private static final float DEFAULT_OFFSET = 0.5f;

    public CropImageView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.offsetHorizontal = 0.5f;
        this.offsetVertical = 0.5f;
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public /* synthetic */ CropImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.applyCropOffset();
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.applyCropOffset();
    }

    public final void setParentLayoutParams(@Nullable ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2 = layoutParams;
        this.parentWidthSpec = layoutParams2 != null ? layoutParams2.width : 0;
        ViewGroup.LayoutParams layoutParams3 = layoutParams;
        this.parentHeightSpec = layoutParams3 != null ? layoutParams3.height : 0;
        this.applyCropOffset();
    }

    public final void setImagePosition(@Nullable Position position) {
        float f;
        float f2;
        this.setScaleType(ImageView.ScaleType.MATRIX);
        Position position2 = position;
        HorizontalPosition horizontalPosition = position2 != null ? position2.getHorizontal() : null;
        switch (horizontalPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[horizontalPosition.ordinal()]) {
            case 1: {
                f2 = 0.0f;
                break;
            }
            case 2: {
                f2 = 0.5f;
                break;
            }
            case 3: {
                f2 = 1.0f;
                break;
            }
            case -1: {
                f2 = 0.5f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.offsetHorizontal = f2;
        Position position3 = position;
        VerticalPosition verticalPosition = position3 != null ? position3.getVertical() : null;
        switch (verticalPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$1[verticalPosition.ordinal()]) {
            case 1: {
                f = 0.0f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 1.0f;
                break;
            }
            case -1: {
                f = 0.5f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.offsetVertical = f;
        this.applyCropOffset();
    }

    private final void applyCropOffset() {
        Matrix matrix;
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Drawable drawable3 = drawable2;
        if (this.getScaleType() != ImageView.ScaleType.MATRIX) {
            return;
        }
        int drawableWidth = drawable3.getIntrinsicWidth();
        int drawableHeight = drawable3.getIntrinsicHeight();
        int viewWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        float scale = this.parentWidthSpec == -1 && this.parentHeightSpec == -2 ? (float)viewWidth / (float)drawableWidth : (this.parentHeightSpec == -1 && this.parentWidthSpec == -2 ? (float)viewHeight / (float)drawableHeight : (drawableWidth * viewHeight > drawableHeight * viewWidth ? (float)viewHeight / (float)drawableHeight : (float)viewWidth / (float)drawableWidth));
        float widthRatio = (float)viewWidth / scale;
        float heightRatio = (float)viewHeight / scale;
        float xOffset = this.offsetHorizontal * ((float)drawableWidth - widthRatio);
        float yOffset = this.offsetVertical * ((float)drawableHeight - heightRatio);
        RectF src = new RectF(xOffset, yOffset, xOffset + widthRatio, yOffset + heightRatio);
        RectF dest = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        Matrix $this$applyCropOffset_u24lambda_u2d0 = matrix = this.getImageMatrix();
        boolean bl = false;
        $this$applyCropOffset_u24lambda_u2d0.setRectToRect(src, dest, Matrix.ScaleToFit.FILL);
        Matrix matrix2 = matrix;
        Intrinsics.checkNotNullExpressionValue((Object)matrix2, (String)"getImageMatrix().apply {\u2026caleToFit.FILL)\n        }");
        Matrix matrix3 = matrix2;
        this.setImageMatrix(matrix3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/urbanairship/android/layout/widget/CropImageView$Companion;", "", "()V", "DEFAULT_OFFSET", "", "urbanairship-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalPosition.values().length];
            nArray[HorizontalPosition.START.ordinal()] = 1;
            nArray[HorizontalPosition.CENTER.ordinal()] = 2;
            nArray[HorizontalPosition.END.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalPosition.values().length];
            nArray[VerticalPosition.TOP.ordinal()] = 1;
            nArray[VerticalPosition.CENTER.ordinal()] = 2;
            nArray[VerticalPosition.BOTTOM.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

