/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.urbanairship.db.RecoverableMigration;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class MessageDatabaseMultiMigration
extends RecoverableMigration {
    static final String NEW_TABLE_NAME = "richpush_new";
    static final String INDEX_MESSAGE_ID = "index_richpush_message_id";

    public MessageDatabaseMultiMigration(int startVersion, int endVersion) {
        super(startVersion, endVersion);
    }

    public void tryMigrate(@NonNull SupportSQLiteDatabase db) {
        this.createTable(db, NEW_TABLE_NAME);
        db.execSQL("DELETE FROM richpush WHERE _id NOT IN (SELECT MIN(_id) FROM richpush GROUP BY message_id)");
        db.execSQL("UPDATE richpush SET unread_orig = 0 WHERE unread_orig IS NULL");
        db.execSQL("UPDATE richpush SET unread = 0 WHERE unread IS NULL");
        db.execSQL("UPDATE richpush SET deleted = 0 WHERE deleted IS NULL");
        db.execSQL("INSERT INTO richpush_new (_id, message_id, message_url, message_body_url, message_read_url, title, extra, unread, unread_orig, deleted, timestamp, raw_message_object, expiration_timestamp) SELECT _id, message_id, message_url, message_body_url, message_read_url, title, extra, unread, unread_orig, deleted, timestamp, raw_message_object, expiration_timestamp FROM richpush");
        this.dropOldAndRenameNewTable(db);
        this.createUniqueIndexOnMessageId(db);
    }

    public void tryRecover(@NonNull SupportSQLiteDatabase db, @NonNull Exception e) {
        db.execSQL("DROP TABLE IF EXISTS richpush_new");
        db.execSQL("DROP TABLE IF EXISTS richpush");
        this.createTable(db, "richpush");
        this.createUniqueIndexOnMessageId(db);
    }

    private void createTable(@NonNull SupportSQLiteDatabase db, @NonNull String name) {
        db.execSQL("CREATE TABLE " + name + " (" + "_id" + " INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, " + "message_id" + " TEXT, " + "message_url" + " TEXT, " + "message_body_url" + " TEXT, " + "message_read_url" + " TEXT, " + "title" + " TEXT, " + "extra" + " TEXT, " + "unread" + " INTEGER NOT NULL, " + "unread_orig" + " INTEGER NOT NULL, " + "deleted" + " INTEGER NOT NULL, " + "timestamp" + " TEXT, " + "raw_message_object" + " TEXT, " + "expiration_timestamp" + " TEXT );");
    }

    private void dropOldAndRenameNewTable(@NonNull SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE richpush");
        db.execSQL("ALTER TABLE richpush_new RENAME TO richpush");
    }

    private void createUniqueIndexOnMessageId(@NonNull SupportSQLiteDatabase db) {
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_richpush_message_id` ON `richpush` (`message_id`)");
    }
}

