/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.urbanairship.Cancelable;
import com.urbanairship.Logger;
import com.urbanairship.messagecenter.Inbox;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.R;
import com.urbanairship.messagecenter.webkit.MessageWebView;
import com.urbanairship.messagecenter.webkit.MessageWebViewClient;
import com.urbanairship.webkit.AirshipWebChromeClient;

public class MessageFragment
extends Fragment {
    public static final String MESSAGE_ID = "messageReporting";
    protected static final int ERROR_FETCHING_MESSAGES = 1;
    protected static final int ERROR_DISPLAYING_MESSAGE = 2;
    protected static final int ERROR_MESSAGE_UNAVAILABLE = 3;
    private MessageWebView webView;
    private View progressBar;
    private Message message;
    private View errorPage;
    private Button retryButton;
    private TextView errorMessage;
    private Integer error = null;
    private Cancelable fetchMessageRequest;

    @NonNull
    public static MessageFragment newInstance(@Nullable String messageId) {
        MessageFragment message = new MessageFragment();
        Bundle arguments = new Bundle();
        arguments.putString(MESSAGE_ID, messageId);
        message.setArguments(arguments);
        return message;
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.ua_fragment_message, container, false);
        this.ensureView(view);
        return view;
    }

    @CallSuper
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureView(view);
    }

    private void ensureView(@NonNull View view) {
        if (this.webView != null) {
            return;
        }
        this.progressBar = view.findViewById(16908301);
        if (this.progressBar == null) {
            throw new RuntimeException("Your content must have a progress View whose id attribute is 'android.R.id.progress'");
        }
        this.webView = (MessageWebView)view.findViewById(16908299);
        if (this.webView == null) {
            throw new RuntimeException("Your content must have a MessageWebView whose id attribute is 'android.R.id.message'");
        }
        this.errorPage = view.findViewById(R.id.error);
        this.webView.setAlpha(0.0f);
        this.webView.setWebViewClient((WebViewClient)new MessageWebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (MessageFragment.this.error != null) {
                    MessageFragment.this.showErrorPage(2);
                } else if (MessageFragment.this.message != null) {
                    MessageFragment.this.message.markRead();
                    MessageFragment.this.showMessage();
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, @Nullable String failingUrl) {
                if (MessageFragment.this.message != null && failingUrl != null && failingUrl.equals(MessageFragment.this.message.getMessageBodyUrl())) {
                    MessageFragment.this.error = errorCode;
                }
            }
        });
        this.webView.getSettings().setSupportMultipleWindows(true);
        this.webView.setWebChromeClient((WebChromeClient)new AirshipWebChromeClient((Activity)this.getActivity()));
        this.retryButton = (Button)view.findViewById(R.id.retry_button);
        if (this.retryButton != null) {
            this.retryButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessageFragment.this.retry();
                }
            });
        }
        this.errorMessage = (TextView)view.findViewById(R.id.error_message);
    }

    public void onStart() {
        super.onStart();
        this.loadMessage();
    }

    public void onResume() {
        super.onResume();
        this.webView.onResume();
    }

    public void onPause() {
        super.onPause();
        this.webView.onPause();
    }

    public void onStop() {
        super.onStop();
        if (this.fetchMessageRequest != null) {
            this.fetchMessageRequest.cancel();
            this.fetchMessageRequest = null;
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.webView = null;
        this.progressBar = null;
    }

    protected void retry() {
        if (this.webView == null) {
            return;
        }
        this.loadMessage();
    }

    protected void showProgress() {
        if (this.errorPage != null && this.errorPage.getVisibility() == 0) {
            this.errorPage.animate().alpha(0.0f).setDuration(200L).setListener(null);
        }
        if (this.webView != null) {
            this.webView.animate().alpha(0.0f).setDuration(200L).setListener(null);
        }
        if (this.progressBar != null) {
            this.progressBar.animate().alpha(1.0f).setDuration(200L).setListener(null);
        }
    }

    protected void showMessage() {
        if (this.webView != null) {
            this.webView.animate().alpha(1.0f).setDuration(200L).setListener(null);
        }
        if (this.progressBar != null) {
            this.progressBar.animate().alpha(0.0f).setDuration(200L).setListener(null);
        }
    }

    protected void showErrorPage(int error) {
        if (this.errorPage != null) {
            switch (error) {
                case 3: {
                    if (this.retryButton != null) {
                        this.retryButton.setVisibility(8);
                    }
                    if (this.errorMessage == null) break;
                    this.errorMessage.setText(R.string.ua_mc_no_longer_available);
                    break;
                }
                case 1: 
                case 2: {
                    if (this.retryButton != null) {
                        this.retryButton.setVisibility(0);
                    }
                    if (this.errorMessage == null) break;
                    this.errorMessage.setText(R.string.ua_mc_failed_to_load);
                }
            }
            if (this.errorPage.getVisibility() == 8) {
                this.errorPage.setAlpha(0.0f);
                this.errorPage.setVisibility(0);
            }
            this.errorPage.animate().alpha(1.0f).setDuration(200L).setListener(null);
        }
        if (this.progressBar != null) {
            this.progressBar.animate().alpha(0.0f).setDuration(200L).setListener(null);
        }
    }

    @Nullable
    public String getMessageId() {
        if (this.getArguments() == null) {
            return null;
        }
        return this.getArguments().getString(MESSAGE_ID);
    }

    private void loadMessage() {
        this.showProgress();
        this.error = null;
        this.message = MessageCenter.shared().getInbox().getMessage(this.getMessageId());
        if (this.message == null) {
            Logger.debug((String)"Fetching messages.", (Object[])new Object[0]);
            this.fetchMessageRequest = MessageCenter.shared().getInbox().fetchMessages(new Inbox.FetchMessagesCallback(){

                @Override
                public void onFinished(boolean success) {
                    MessageFragment.this.message = MessageCenter.shared().getInbox().getMessage(MessageFragment.this.getMessageId());
                    if (!success) {
                        MessageFragment.this.showErrorPage(1);
                        return;
                    }
                    if (MessageFragment.this.message == null || MessageFragment.this.message.isExpired()) {
                        MessageFragment.this.showErrorPage(3);
                        return;
                    }
                    Logger.info((String)("Loading message: " + MessageFragment.this.message.getMessageId()), (Object[])new Object[0]);
                    MessageFragment.this.webView.loadMessage(MessageFragment.this.message);
                }
            });
        } else {
            if (this.message.isExpired()) {
                this.showErrorPage(3);
                return;
            }
            Logger.info((String)"Loading message: %s", (Object[])new Object[]{this.message.getMessageId()});
            this.webView.loadMessage(this.message);
        }
    }
}

