/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter.actions;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.actions.Action;
import com.urbanairship.actions.ActionArguments;
import com.urbanairship.actions.ActionResult;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.push.PushMessage;
import com.urbanairship.util.AirshipComponentUtils;
import com.urbanairship.util.UAStringUtil;
import java.util.concurrent.Callable;

public class MessageCenterAction
extends Action {
    @NonNull
    public static final String DEFAULT_REGISTRY_NAME = "open_mc_action";
    @NonNull
    public static final String DEFAULT_REGISTRY_SHORT_NAME = "^mc";
    @NonNull
    public static final String MESSAGE_ID_PLACEHOLDER = "auto";
    private final Callable<MessageCenter> messageCenterCallable;

    public boolean acceptsArguments(@NonNull ActionArguments arguments) {
        switch (arguments.getSituation()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public MessageCenterAction() {
        this(AirshipComponentUtils.callableForComponent(MessageCenter.class));
    }

    @VisibleForTesting
    MessageCenterAction(@NonNull Callable<MessageCenter> messageCenterCallable) {
        this.messageCenterCallable = messageCenterCallable;
    }

    @NonNull
    public ActionResult perform(@NonNull ActionArguments arguments) {
        MessageCenter messageCenter;
        try {
            messageCenter = this.messageCenterCallable.call();
        }
        catch (Exception e) {
            return ActionResult.newErrorResult((Exception)e);
        }
        String messageId = arguments.getValue().getString();
        if (MESSAGE_ID_PLACEHOLDER.equalsIgnoreCase(messageId)) {
            PushMessage pushMessage = (PushMessage)arguments.getMetadata().getParcelable("com.urbanairship.PUSH_MESSAGE");
            messageId = pushMessage != null && pushMessage.getRichPushMessageId() != null ? pushMessage.getRichPushMessageId() : (arguments.getMetadata().containsKey("com.urbanairship.RICH_PUSH_ID_METADATA") ? arguments.getMetadata().getString("com.urbanairship.RICH_PUSH_ID_METADATA") : null);
        }
        if (UAStringUtil.isEmpty((String)messageId)) {
            messageCenter.showMessageCenter();
        } else {
            messageCenter.showMessageCenter(messageId);
        }
        return ActionResult.newEmptyResult();
    }

    public boolean shouldRunOnMainThread() {
        return true;
    }
}

