/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.urbanairship.messagecenter.MessageDao;
import com.urbanairship.messagecenter.MessageEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MessageDao_Impl
extends MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MessageEntity> __insertionAdapterOfMessageEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllMessagesInternal;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessageEntity = new EntityInsertionAdapter<MessageEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `richpush` (`_id`,`message_id`,`message_url`,`message_body_url`,`message_read_url`,`title`,`extra`,`unread`,`unread_orig`,`deleted`,`timestamp`,`raw_message_object`,`expiration_timestamp`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MessageEntity value) {
                stmt.bindLong(1, (long)value.id);
                if (value.messageId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.messageId);
                }
                if (value.messageUrl == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.messageUrl);
                }
                if (value.messageBodyUrl == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.messageBodyUrl);
                }
                if (value.messageReadUrl == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.messageReadUrl);
                }
                if (value.title == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.title);
                }
                if (value.extra == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.extra);
                }
                int _tmp = value.unread ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                int _tmp_1 = value.unreadOrig ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_1);
                int _tmp_2 = value.deleted ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_2);
                if (value.timestamp == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.timestamp);
                }
                if (value.rawMessageObject == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.rawMessageObject);
                }
                if (value.expirationTimestamp == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.expirationTimestamp);
                }
            }
        };
        this.__preparedStmtOfDeleteAllMessagesInternal = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM richpush";
                return "DELETE FROM richpush";
            }
        };
    }

    @Override
    protected void insertInternal(MessageEntity message) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageEntity.insert((Object)message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    protected void insertMessagesInternal(List<MessageEntity> messages) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessageEntity.insert(messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    protected void deleteMessagesInternal(List<String> messageIds) {
        this.__db.beginTransaction();
        try {
            MessageDao_Impl.super.deleteMessagesInternal(messageIds);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    protected void deleteAllMessagesInternal() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllMessagesInternal.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllMessagesInternal.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MessageEntity> getMessagesInternal() {
        String _sql = "SELECT * FROM richpush";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM richpush", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<MessageEntity> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
                int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_id");
                int _cursorIndexOfMessageUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_url");
                int _cursorIndexOfMessageBodyUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_body_url");
                int _cursorIndexOfMessageReadUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_read_url");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                int _cursorIndexOfExtra = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra");
                int _cursorIndexOfUnread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread");
                int _cursorIndexOfUnreadOrig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread_orig");
                int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                int _cursorIndexOfRawMessageObject = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"raw_message_object");
                int _cursorIndexOfExpirationTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiration_timestamp");
                ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                    String _tmpMessageUrl = _cursor.isNull(_cursorIndexOfMessageUrl) ? null : _cursor.getString(_cursorIndexOfMessageUrl);
                    String _tmpMessageBodyUrl = _cursor.isNull(_cursorIndexOfMessageBodyUrl) ? null : _cursor.getString(_cursorIndexOfMessageBodyUrl);
                    String _tmpMessageReadUrl = _cursor.isNull(_cursorIndexOfMessageReadUrl) ? null : _cursor.getString(_cursorIndexOfMessageReadUrl);
                    String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                    String _tmpExtra = _cursor.isNull(_cursorIndexOfExtra) ? null : _cursor.getString(_cursorIndexOfExtra);
                    int _tmp = _cursor.getInt(_cursorIndexOfUnread);
                    boolean _tmpUnread = _tmp != 0;
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfUnreadOrig);
                    boolean _tmpUnreadOrig = _tmp_1 != 0;
                    int _tmp_2 = _cursor.getInt(_cursorIndexOfDeleted);
                    boolean _tmpDeleted = _tmp_2 != 0;
                    String _tmpTimestamp = _cursor.isNull(_cursorIndexOfTimestamp) ? null : _cursor.getString(_cursorIndexOfTimestamp);
                    String _tmpRawMessageObject = _cursor.isNull(_cursorIndexOfRawMessageObject) ? null : _cursor.getString(_cursorIndexOfRawMessageObject);
                    String _tmpExpirationTimestamp = _cursor.isNull(_cursorIndexOfExpirationTimestamp) ? null : _cursor.getString(_cursorIndexOfExpirationTimestamp);
                    MessageEntity _item = new MessageEntity(_tmpMessageId, _tmpMessageUrl, _tmpMessageBodyUrl, _tmpMessageReadUrl, _tmpTitle, _tmpExtra, _tmpUnread, _tmpUnreadOrig, _tmpDeleted, _tmpTimestamp, _tmpRawMessageObject, _tmpExpirationTimestamp);
                    _item.id = _cursor.getInt(_cursorIndexOfId);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getMessageIdsInternal() {
        String _sql = "SELECT message_id FROM richpush";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message_id FROM richpush", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<String> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MessageEntity> getLocallyReadMessagesInternal() {
        String _sql = "SELECT * FROM richpush WHERE unread = 0 AND unread <> unread_orig";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM richpush WHERE unread = 0 AND unread <> unread_orig", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<MessageEntity> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
                int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_id");
                int _cursorIndexOfMessageUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_url");
                int _cursorIndexOfMessageBodyUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_body_url");
                int _cursorIndexOfMessageReadUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_read_url");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                int _cursorIndexOfExtra = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra");
                int _cursorIndexOfUnread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread");
                int _cursorIndexOfUnreadOrig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread_orig");
                int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                int _cursorIndexOfRawMessageObject = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"raw_message_object");
                int _cursorIndexOfExpirationTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiration_timestamp");
                ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                    String _tmpMessageUrl = _cursor.isNull(_cursorIndexOfMessageUrl) ? null : _cursor.getString(_cursorIndexOfMessageUrl);
                    String _tmpMessageBodyUrl = _cursor.isNull(_cursorIndexOfMessageBodyUrl) ? null : _cursor.getString(_cursorIndexOfMessageBodyUrl);
                    String _tmpMessageReadUrl = _cursor.isNull(_cursorIndexOfMessageReadUrl) ? null : _cursor.getString(_cursorIndexOfMessageReadUrl);
                    String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                    String _tmpExtra = _cursor.isNull(_cursorIndexOfExtra) ? null : _cursor.getString(_cursorIndexOfExtra);
                    int _tmp = _cursor.getInt(_cursorIndexOfUnread);
                    boolean _tmpUnread = _tmp != 0;
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfUnreadOrig);
                    boolean _tmpUnreadOrig = _tmp_1 != 0;
                    int _tmp_2 = _cursor.getInt(_cursorIndexOfDeleted);
                    boolean _tmpDeleted = _tmp_2 != 0;
                    String _tmpTimestamp = _cursor.isNull(_cursorIndexOfTimestamp) ? null : _cursor.getString(_cursorIndexOfTimestamp);
                    String _tmpRawMessageObject = _cursor.isNull(_cursorIndexOfRawMessageObject) ? null : _cursor.getString(_cursorIndexOfRawMessageObject);
                    String _tmpExpirationTimestamp = _cursor.isNull(_cursorIndexOfExpirationTimestamp) ? null : _cursor.getString(_cursorIndexOfExpirationTimestamp);
                    MessageEntity _item = new MessageEntity(_tmpMessageId, _tmpMessageUrl, _tmpMessageBodyUrl, _tmpMessageReadUrl, _tmpTitle, _tmpExtra, _tmpUnread, _tmpUnreadOrig, _tmpDeleted, _tmpTimestamp, _tmpRawMessageObject, _tmpExpirationTimestamp);
                    _item.id = _cursor.getInt(_cursorIndexOfId);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MessageEntity> getLocallyDeletedMessagesInternal() {
        String _sql = "SELECT * FROM richpush WHERE deleted = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM richpush WHERE deleted = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<MessageEntity> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
                int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_id");
                int _cursorIndexOfMessageUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_url");
                int _cursorIndexOfMessageBodyUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_body_url");
                int _cursorIndexOfMessageReadUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message_read_url");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                int _cursorIndexOfExtra = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra");
                int _cursorIndexOfUnread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread");
                int _cursorIndexOfUnreadOrig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unread_orig");
                int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                int _cursorIndexOfRawMessageObject = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"raw_message_object");
                int _cursorIndexOfExpirationTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiration_timestamp");
                ArrayList<MessageEntity> _result = new ArrayList<MessageEntity>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpMessageId = _cursor.isNull(_cursorIndexOfMessageId) ? null : _cursor.getString(_cursorIndexOfMessageId);
                    String _tmpMessageUrl = _cursor.isNull(_cursorIndexOfMessageUrl) ? null : _cursor.getString(_cursorIndexOfMessageUrl);
                    String _tmpMessageBodyUrl = _cursor.isNull(_cursorIndexOfMessageBodyUrl) ? null : _cursor.getString(_cursorIndexOfMessageBodyUrl);
                    String _tmpMessageReadUrl = _cursor.isNull(_cursorIndexOfMessageReadUrl) ? null : _cursor.getString(_cursorIndexOfMessageReadUrl);
                    String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                    String _tmpExtra = _cursor.isNull(_cursorIndexOfExtra) ? null : _cursor.getString(_cursorIndexOfExtra);
                    int _tmp = _cursor.getInt(_cursorIndexOfUnread);
                    boolean _tmpUnread = _tmp != 0;
                    int _tmp_1 = _cursor.getInt(_cursorIndexOfUnreadOrig);
                    boolean _tmpUnreadOrig = _tmp_1 != 0;
                    int _tmp_2 = _cursor.getInt(_cursorIndexOfDeleted);
                    boolean _tmpDeleted = _tmp_2 != 0;
                    String _tmpTimestamp = _cursor.isNull(_cursorIndexOfTimestamp) ? null : _cursor.getString(_cursorIndexOfTimestamp);
                    String _tmpRawMessageObject = _cursor.isNull(_cursorIndexOfRawMessageObject) ? null : _cursor.getString(_cursorIndexOfRawMessageObject);
                    String _tmpExpirationTimestamp = _cursor.isNull(_cursorIndexOfExpirationTimestamp) ? null : _cursor.getString(_cursorIndexOfExpirationTimestamp);
                    MessageEntity _item = new MessageEntity(_tmpMessageId, _tmpMessageUrl, _tmpMessageBodyUrl, _tmpMessageReadUrl, _tmpTitle, _tmpExtra, _tmpUnread, _tmpUnreadOrig, _tmpDeleted, _tmpTimestamp, _tmpRawMessageObject, _tmpExpirationTimestamp);
                    _item.id = _cursor.getInt(_cursorIndexOfId);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean messageExistsInternal(String id2) {
        String _sql = "SELECT EXISTS (SELECT 1 FROM richpush WHERE message_id = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT EXISTS (SELECT 1 FROM richpush WHERE message_id = ?)", (int)1);
        int _argIndex = 1;
        if (id2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id2);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markMessagesReadInternal(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE richpush SET unread = 0 WHERE message_id IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markMessagesUnreadInternal(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE richpush SET unread = 1 WHERE message_id IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markMessagesDeletedInternal(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE richpush SET deleted = 1 WHERE message_id IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void markMessagesReadOriginInternal(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE richpush SET unread_orig = 0 WHERE message_id IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMessagesBatchInternal(List<String> messageIds) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM richpush WHERE message_id IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

