/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.urbanairship.messagecenter.MessageDao;
import com.urbanairship.messagecenter.MessageDao_Impl;
import com.urbanairship.messagecenter.MessageDatabase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MessageDatabase_Impl
extends MessageDatabase {
    private volatile MessageDao _messageDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(5){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `richpush` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `message_id` TEXT, `message_url` TEXT, `message_body_url` TEXT, `message_read_url` TEXT, `title` TEXT, `extra` TEXT, `unread` INTEGER NOT NULL, `unread_orig` INTEGER NOT NULL, `deleted` INTEGER NOT NULL, `timestamp` TEXT, `raw_message_object` TEXT, `expiration_timestamp` TEXT)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_richpush_message_id` ON `richpush` (`message_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '867ae7d13f0985895f1665a5fc7b7a17')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `richpush`");
                if (MessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MessageDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (MessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MessageDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                MessageDatabase_Impl.this.mDatabase = _db;
                MessageDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (MessageDatabase_Impl.this.mCallbacks != null) {
                    int _size = MessageDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MessageDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsRichpush = new HashMap<String, TableInfo.Column>(13);
                _columnsRichpush.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsRichpush.put("message_id", new TableInfo.Column("message_id", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("message_url", new TableInfo.Column("message_url", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("message_body_url", new TableInfo.Column("message_body_url", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("message_read_url", new TableInfo.Column("message_read_url", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("extra", new TableInfo.Column("extra", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("unread", new TableInfo.Column("unread", "INTEGER", true, 0, null, 1));
                _columnsRichpush.put("unread_orig", new TableInfo.Column("unread_orig", "INTEGER", true, 0, null, 1));
                _columnsRichpush.put("deleted", new TableInfo.Column("deleted", "INTEGER", true, 0, null, 1));
                _columnsRichpush.put("timestamp", new TableInfo.Column("timestamp", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("raw_message_object", new TableInfo.Column("raw_message_object", "TEXT", false, 0, null, 1));
                _columnsRichpush.put("expiration_timestamp", new TableInfo.Column("expiration_timestamp", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysRichpush = new HashSet(0);
                HashSet<TableInfo.Index> _indicesRichpush = new HashSet<TableInfo.Index>(1);
                _indicesRichpush.add(new TableInfo.Index("index_richpush_message_id", true, Arrays.asList("message_id"), Arrays.asList("ASC")));
                TableInfo _infoRichpush = new TableInfo("richpush", _columnsRichpush, _foreignKeysRichpush, _indicesRichpush);
                TableInfo _existingRichpush = TableInfo.read((SupportSQLiteDatabase)_db, (String)"richpush");
                if (!_infoRichpush.equals((Object)_existingRichpush)) {
                    return new RoomOpenHelper.ValidationResult(false, "richpush(com.urbanairship.messagecenter.MessageEntity).\n Expected:\n" + _infoRichpush + "\n Found:\n" + _existingRichpush);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "867ae7d13f0985895f1665a5fc7b7a17", "d9f9d711f596d7f406febbe363d73f40");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"richpush"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `richpush`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MessageDao.class, MessageDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDao getDao() {
        if (this._messageDao != null) {
            return this._messageDao;
        }
        MessageDatabase_Impl messageDatabase_Impl = this;
        synchronized (messageDatabase_Impl) {
            if (this._messageDao == null) {
                this._messageDao = new MessageDao_Impl(this);
            }
            return this._messageDao;
        }
    }
}

