/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.format.DateFormat;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.urbanairship.UAirship;
import com.urbanairship.images.ImageRequestOptions;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.R;
import com.urbanairship.util.AccessibilityUtils;
import com.urbanairship.util.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public class MessageItemView
extends FrameLayout {
    private static final int[] STATE_HIGHLIGHTED = new int[]{R.attr.ua_state_highlighted};
    private View contentView;
    private TextView titleView;
    private TextView dateView;
    private ImageView iconView;
    private CheckBox checkBox;
    private final List<Integer> accessibilityActionIds = new ArrayList<Integer>();
    private boolean isHighlighted;
    private View.OnClickListener selectionListener;

    public MessageItemView(@NonNull Context context) {
        this(context, null, R.attr.messageCenterStyle);
    }

    public MessageItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.messageCenterStyle);
    }

    public MessageItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, R.style.MessageCenter);
    }

    public MessageItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int contentLayout = R.layout.ua_item_mc_content;
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageCenter, defStyleAttr, defStyleRes);
        if (attributes.getBoolean(R.styleable.MessageCenter_messageCenterItemIconEnabled, false)) {
            contentLayout = R.layout.ua_item_mc_icon_content;
        }
        int dateTextAppearance = attributes.getResourceId(R.styleable.MessageCenter_messageCenterItemDateTextAppearance, 0);
        int titleTextAppearance = attributes.getResourceId(R.styleable.MessageCenter_messageCenterItemTitleTextAppearance, 0);
        int background = attributes.getResourceId(R.styleable.MessageCenter_messageCenterItemBackground, 0);
        if (background != 0) {
            this.setBackgroundResource(background);
        }
        attributes.recycle();
        this.contentView = View.inflate((Context)context, (int)contentLayout, (ViewGroup)this);
        this.titleView = (TextView)this.contentView.findViewById(R.id.title);
        ViewUtils.applyTextStyle((Context)context, (TextView)this.titleView, (int)titleTextAppearance);
        this.dateView = (TextView)this.contentView.findViewById(R.id.date);
        ViewUtils.applyTextStyle((Context)context, (TextView)this.dateView, (int)dateTextAppearance);
        this.iconView = (ImageView)this.contentView.findViewById(R.id.image);
        if (this.iconView != null) {
            this.iconView.setOnClickListener(v -> {
                if (this.selectionListener != null) {
                    this.selectionListener.onClick((View)this);
                }
            });
        }
        this.checkBox = (CheckBox)this.contentView.findViewById(R.id.checkbox);
        if (this.checkBox != null) {
            this.checkBox.setOnClickListener(v -> {
                if (this.selectionListener != null) {
                    this.selectionListener.onClick((View)this);
                }
            });
        }
    }

    void updateMessage(@NonNull Message message, @DrawableRes int placeholder, boolean isSelected) {
        this.dateView.setText((CharSequence)DateFormat.getDateFormat((Context)this.getContext()).format(message.getSentDate()));
        if (message.isRead()) {
            this.titleView.setText((CharSequence)message.getTitle());
        } else {
            SpannableString text = new SpannableString((CharSequence)message.getTitle());
            text.setSpan((Object)new StyleSpan(1), 0, text.length(), 0);
            this.titleView.setText((CharSequence)text, TextView.BufferType.SPANNABLE);
        }
        if (this.checkBox != null) {
            this.checkBox.setChecked(isSelected);
        }
        if (this.iconView != null) {
            ImageRequestOptions options = ImageRequestOptions.newBuilder((String)message.getListIconUrl()).setPlaceHolder(placeholder).build();
            UAirship.shared().getImageLoader().load(this.getContext(), this.iconView, options);
        }
        this.contentView.setContentDescription((CharSequence)MessageItemView.buildContentDescription(this.getContext(), message, isSelected));
        this.updateAccessibilityActions(this.contentView, isSelected);
    }

    public void setActivated(boolean activated) {
        super.setActivated(activated);
        if (this.checkBox != null) {
            this.checkBox.setChecked(activated);
        }
    }

    void setHighlighted(boolean isHighlighted) {
        if (this.isHighlighted != isHighlighted) {
            this.isHighlighted = isHighlighted;
            this.refreshDrawableState();
        }
    }

    void setSelectionListener(@Nullable View.OnClickListener listener) {
        this.selectionListener = listener;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.isHighlighted) {
            int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
            MessageItemView.mergeDrawableStates((int[])drawableState, (int[])STATE_HIGHLIGHTED);
            return drawableState;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    private void updateAccessibilityActions(@NonNull View view, boolean isActivated) {
        for (int actionId : this.accessibilityActionIds) {
            ViewCompat.removeAccessibilityAction((View)view, (int)actionId);
        }
        String actionLabel = this.getContext().getString(isActivated ? R.string.ua_mc_action_unselect : R.string.ua_mc_action_select);
        this.accessibilityActionIds.add(ViewCompat.addAccessibilityAction((View)view, (CharSequence)actionLabel, (v, args) -> {
            if (this.selectionListener != null) {
                this.selectionListener.onClick((View)this);
            }
            return true;
        }));
        AccessibilityUtils.setClickActionLabel((View)view, (int)R.string.ua_mc_action_click);
    }

    @NonNull
    private static String buildContentDescription(@NonNull Context context, @NonNull Message message, boolean isSelected) {
        StringBuilder sb = new StringBuilder();
        if (isSelected) {
            sb.append(context.getString(R.string.ua_mc_description_state_selected));
        }
        if (!message.isRead()) {
            sb.append(context.getString(R.string.ua_mc_description_state_unread));
        }
        sb.append(context.getString(R.string.ua_mc_description_title_and_date, new Object[]{message.getTitle(), DateFormat.getLongDateFormat((Context)context).format(message.getSentDate())}));
        return sb.toString();
    }
}

