/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.channel.AirshipChannel;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.util.UAStringUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class User {
    private static final String KEY_PREFIX = "com.urbanairship.user";
    private static final String USER_ID_KEY = "com.urbanairship.user.ID";
    private static final String USER_PASSWORD_KEY = "com.urbanairship.user.PASSWORD";
    private static final String USER_TOKEN_KEY = "com.urbanairship.user.USER_TOKEN";
    private static final String USER_REGISTERED_CHANNEL_ID_KEY = "com.urbanairship.user.REGISTERED_CHANNEL_ID";
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final PreferenceDataStore preferences;
    private final AirshipChannel channel;

    User(@NonNull PreferenceDataStore preferenceDataStore, @NonNull AirshipChannel channel) {
        String userToken;
        this.preferences = preferenceDataStore;
        this.channel = channel;
        String password = this.preferences.getString(USER_PASSWORD_KEY, null);
        if (!UAStringUtil.isEmpty((String)password) && this.preferences.putSync(USER_TOKEN_KEY, userToken = User.encode(password, this.preferences.getString(USER_ID_KEY, null)))) {
            this.preferences.remove(USER_PASSWORD_KEY);
        }
    }

    public void addListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull Listener listener) {
        this.listeners.remove(listener);
    }

    void onUserUpdated(boolean success) {
        for (Listener listener : this.listeners) {
            listener.onUserUpdated(success);
        }
    }

    void onUpdated(@NonNull String channelId) {
        if (!channelId.equals(this.getRegisteredChannelId())) {
            this.preferences.put(USER_REGISTERED_CHANNEL_ID_KEY, channelId);
        }
    }

    void onCreated(@NonNull String userId, @NonNull String userToken, @NonNull String channelId) {
        this.setRegisteredChannelId(channelId);
        this.setUser(userId, userToken);
    }

    public static boolean isCreated() {
        return MessageCenter.shared().getUser().isUserCreated();
    }

    public boolean isUserCreated() {
        return !UAStringUtil.isEmpty((String)this.getId()) && !UAStringUtil.isEmpty((String)this.getPassword());
    }

    void setUser(@NonNull String userId, @NonNull String userToken) {
        Logger.debug((String)"Setting Rich Push user: %s", (Object[])new Object[]{userId});
        this.preferences.put(USER_ID_KEY, userId);
        this.preferences.put(USER_TOKEN_KEY, User.encode(userToken, userId));
    }

    @Nullable
    public String getId() {
        if (this.preferences.getString(USER_TOKEN_KEY, null) != null) {
            return this.preferences.getString(USER_ID_KEY, null);
        }
        return null;
    }

    @Nullable
    public String getPassword() {
        if (this.preferences.getString(USER_ID_KEY, null) != null) {
            return User.decode(this.preferences.getString(USER_TOKEN_KEY, null), this.getId());
        }
        return null;
    }

    @Nullable
    private static String encode(@Nullable String input, @Nullable String key) {
        if (UAStringUtil.isEmpty((String)input) || UAStringUtil.isEmpty((String)key)) {
            return null;
        }
        byte[] bytes = User.xor(input.getBytes(), key.getBytes());
        StringBuilder hexHash = new StringBuilder();
        for (byte b : bytes) {
            hexHash.append(String.format("%02x", b));
        }
        return hexHash.toString();
    }

    @Nullable
    private static String decode(@Nullable String encodedString, @Nullable String key) {
        if (UAStringUtil.isEmpty((String)encodedString) || UAStringUtil.isEmpty((String)key)) {
            return null;
        }
        int length = encodedString.length();
        if (length % 2 != 0) {
            return null;
        }
        try {
            byte[] decodedBytes = new byte[length / 2];
            for (int i = 0; i < length; i += 2) {
                decodedBytes[i / 2] = Byte.parseByte(encodedString.substring(i, i + 2), 16);
            }
            decodedBytes = User.xor(decodedBytes, key.getBytes());
            return new String(decodedBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((Throwable)e, (String)"RichPushUser - Unable to decode string.", (Object[])new Object[0]);
        }
        catch (NumberFormatException e) {
            Logger.error((Throwable)e, (String)"RichPushUser - String contains invalid hex numbers.", (Object[])new Object[0]);
        }
        return null;
    }

    private static byte[] xor(@NonNull byte[] a, @NonNull byte[] b) {
        byte[] out = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = (byte)(a[i] ^ b[i % b.length]);
        }
        return out;
    }

    @NonNull
    private String getRegisteredChannelId() {
        return this.preferences.getString(USER_REGISTERED_CHANNEL_ID_KEY, "");
    }

    private void setRegisteredChannelId(@NonNull String channelId) {
        this.preferences.put(USER_REGISTERED_CHANNEL_ID_KEY, channelId);
    }

    boolean shouldUpdate() {
        return this.channel.getId() != null && !this.getRegisteredChannelId().equals(this.channel.getId());
    }

    public static interface Listener {
        public void onUserUpdated(boolean var1);
    }
}

