/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter.webkit;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.User;
import com.urbanairship.webkit.AirshipWebView;
import java.util.HashMap;

public class MessageWebView
extends AirshipWebView {
    public MessageWebView(@NonNull Context context) {
        super(context);
    }

    public MessageWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MessageWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public MessageWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
    }

    public void loadMessage(@NonNull Message message) {
        User user = MessageCenter.shared().getUser();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (user.getId() != null && user.getPassword() != null) {
            this.setClientAuthRequest(message.getMessageBodyUrl(), user.getId(), user.getPassword());
            headers.put("Authorization", this.createBasicAuth(user.getId(), user.getPassword()));
        }
        this.loadUrl(message.getMessageBodyUrl(), headers);
    }
}

