/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.res.Resources;
import android.util.SparseBooleanArray;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.AbsListView;
import androidx.annotation.NonNull;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageListFragment;
import com.urbanairship.messagecenter.R;
import java.util.HashSet;
import java.util.Set;

public class DefaultMultiChoiceModeListener
implements AbsListView.MultiChoiceModeListener {
    private final MessageListFragment messageListFragment;

    public DefaultMultiChoiceModeListener(@NonNull MessageListFragment messageListFragment) {
        this.messageListFragment = messageListFragment;
    }

    public void onItemCheckedStateChanged(@NonNull ActionMode mode, int position, long id2, boolean checked) {
        if (this.messageListFragment.getAbsListView() == null) {
            return;
        }
        int count = this.messageListFragment.getAbsListView().getCheckedItemCount();
        mode.setTitle((CharSequence)this.messageListFragment.getResources().getQuantityString(R.plurals.ua_selected_count, count, new Object[]{count}));
        if (this.messageListFragment.getAdapter() != null) {
            this.messageListFragment.getAdapter().notifyDataSetChanged();
        }
        mode.invalidate();
    }

    public boolean onCreateActionMode(@NonNull ActionMode mode, @NonNull Menu menu2) {
        if (this.messageListFragment.getAbsListView() == null) {
            return false;
        }
        mode.getMenuInflater().inflate(R.menu.ua_mc_action_mode, menu2);
        int count = this.messageListFragment.getAbsListView().getCheckedItemCount();
        mode.setTitle((CharSequence)this.messageListFragment.getResources().getQuantityString(R.plurals.ua_selected_count, count, new Object[]{count}));
        boolean containsUnreadMessage = false;
        SparseBooleanArray checked = this.messageListFragment.getAbsListView().getCheckedItemPositions();
        for (int i = 0; i < checked.size(); ++i) {
            Message message;
            if (!checked.valueAt(i) || (message = this.messageListFragment.getMessage(checked.keyAt(i))) == null || message.isRead()) continue;
            containsUnreadMessage = true;
            break;
        }
        MenuItem markRead = menu2.findItem(R.id.mark_read);
        markRead.setVisible(containsUnreadMessage);
        return true;
    }

    public boolean onPrepareActionMode(@NonNull ActionMode mode, @NonNull Menu menu2) {
        if (this.messageListFragment.getAbsListView() == null) {
            return false;
        }
        boolean containsUnreadMessage = false;
        SparseBooleanArray checked = this.messageListFragment.getAbsListView().getCheckedItemPositions();
        for (int i = 0; i < checked.size(); ++i) {
            Message message;
            if (!checked.valueAt(i) || (message = this.messageListFragment.getMessage(checked.keyAt(i))) == null || message.isRead()) continue;
            containsUnreadMessage = true;
            break;
        }
        MenuItem markRead = menu2.findItem(R.id.mark_read);
        markRead.setVisible(containsUnreadMessage);
        return true;
    }

    public boolean onActionItemClicked(@NonNull ActionMode mode, @NonNull MenuItem item) {
        AbsListView listView = this.messageListFragment.getAbsListView();
        if (listView == null) {
            return false;
        }
        Resources res = listView.getContext().getResources();
        if (item.getItemId() == R.id.mark_read) {
            MessageCenter.shared().getInbox().markMessagesRead(this.getCheckedMessageIds());
            int count = this.getCheckedMessageIds().size();
            listView.announceForAccessibility((CharSequence)res.getQuantityString(R.plurals.ua_mc_description_marked_read, count, new Object[]{count}));
            mode.finish();
        } else if (item.getItemId() == R.id.delete) {
            MessageCenter.shared().getInbox().deleteMessages(this.getCheckedMessageIds());
            int count = this.getCheckedMessageIds().size();
            listView.announceForAccessibility((CharSequence)res.getQuantityString(R.plurals.ua_mc_description_deleted, count, new Object[]{count}));
            mode.finish();
        } else if (item.getItemId() == R.id.select_all) {
            for (int i = 0; i < listView.getCount(); ++i) {
                listView.setItemChecked(i, true);
            }
        }
        return true;
    }

    public void onDestroyActionMode(@NonNull ActionMode mode) {
    }

    @NonNull
    private Set<String> getCheckedMessageIds() {
        HashSet<String> messageIds = new HashSet<String>();
        if (this.messageListFragment.getAbsListView() == null) {
            return messageIds;
        }
        SparseBooleanArray checked = this.messageListFragment.getAbsListView().getCheckedItemPositions();
        for (int i = 0; i < checked.size(); ++i) {
            Message message;
            if (!checked.valueAt(i) || (message = this.messageListFragment.getMessage(checked.keyAt(i))) == null) continue;
            messageIds.add(message.getMessageId());
        }
        return messageIds;
    }
}

