/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.config.AirshipUrlConfig;
import com.urbanairship.config.UrlBuilder;
import com.urbanairship.http.RequestException;
import com.urbanairship.http.RequestFactory;
import com.urbanairship.http.Response;
import com.urbanairship.http.ResponseParser;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.User;
import com.urbanairship.messagecenter.UserCredentials;
import com.urbanairship.util.UAHttpStatusUtil;
import com.urbanairship.util.UAStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxApiClient {
    private static final String USER_API_PATH = "api/user/";
    private static final String DELETE_MESSAGES_PATH = "messages/delete/";
    private static final String MARK_READ_MESSAGES_PATH = "messages/unread/";
    private static final String MESSAGES_PATH = "messages/";
    private static final String MESSAGES_REPORTINGS_KEY = "messages";
    private static final String CHANNEL_ID_HEADER = "X-UA-Channel-ID";
    private static final String PAYLOAD_AMAZON_CHANNELS_KEY = "amazon_channels";
    private static final String PAYLOAD_ANDROID_CHANNELS_KEY = "android_channels";
    private static final String PAYLOAD_ADD_KEY = "add";
    private final AirshipRuntimeConfig runtimeConfig;
    private final RequestFactory requestFactory;

    InboxApiClient(@NonNull AirshipRuntimeConfig runtimeConfig) {
        this(runtimeConfig, RequestFactory.DEFAULT_REQUEST_FACTORY);
    }

    InboxApiClient(@NonNull AirshipRuntimeConfig runtimeConfig, @NonNull RequestFactory requestFactory) {
        this.runtimeConfig = runtimeConfig;
        this.requestFactory = requestFactory;
    }

    @NonNull
    Response<JsonList> fetchMessages(@NonNull User user, @NonNull String channelId, long lastMessageRefreshTime) throws RequestException {
        Uri url = this.getUserApiUrl(this.runtimeConfig.getUrlConfig(), user.getId(), MESSAGES_PATH);
        return this.requestFactory.createRequest().setOperation("GET", url).setCredentials(user.getId(), user.getPassword()).setAirshipJsonAcceptsHeader().setAirshipUserAgent(this.runtimeConfig).setHeader(CHANNEL_ID_HEADER, channelId).setIfModifiedSince(lastMessageRefreshTime).execute((ResponseParser)new ResponseParser<JsonList>(){

            public JsonList parseResponse(int status, @Nullable Map<String, List<String>> headers, @Nullable String responseBody) throws Exception {
                if (!UAHttpStatusUtil.inSuccessRange((int)status)) {
                    return null;
                }
                JsonList messageJson = JsonValue.parseString((String)responseBody).optMap().opt(InboxApiClient.MESSAGES_REPORTINGS_KEY).getList();
                if (messageJson == null) {
                    throw new JsonException("Invalid response, missing messages.");
                }
                return messageJson;
            }
        });
    }

    Response<Void> syncDeletedMessageState(@NonNull User user, @NonNull String channelId, @NonNull List<JsonValue> reportingsToDelete) throws RequestException {
        AirshipUrlConfig urlConfig = this.runtimeConfig.getUrlConfig();
        Uri url = this.getUserApiUrl(urlConfig, user.getId(), DELETE_MESSAGES_PATH);
        JsonMap payload = JsonMap.newBuilder().put(MESSAGES_REPORTINGS_KEY, (JsonSerializable)JsonValue.wrapOpt(reportingsToDelete)).build();
        Logger.verbose((String)"Deleting inbox messages with payload: %s", (Object[])new Object[]{payload});
        return this.requestFactory.createRequest().setOperation("POST", url).setCredentials(user.getId(), user.getPassword()).setRequestBody(payload.toString(), "application/json").setHeader(CHANNEL_ID_HEADER, channelId).setAirshipJsonAcceptsHeader().setAirshipUserAgent(this.runtimeConfig).execute();
    }

    Response<Void> syncReadMessageState(@NonNull User user, @NonNull String channelId, @NonNull List<JsonValue> reportingsToUpdate) throws RequestException {
        AirshipUrlConfig urlConfig = this.runtimeConfig.getUrlConfig();
        Uri url = this.getUserApiUrl(urlConfig, user.getId(), MARK_READ_MESSAGES_PATH);
        JsonMap payload = JsonMap.newBuilder().put(MESSAGES_REPORTINGS_KEY, (JsonSerializable)JsonValue.wrapOpt(reportingsToUpdate)).build();
        Logger.verbose((String)"Marking inbox messages read request with payload: %s", (Object[])new Object[]{payload});
        return this.requestFactory.createRequest().setOperation("POST", url).setCredentials(user.getId(), user.getPassword()).setRequestBody(payload.toString(), "application/json").setHeader(CHANNEL_ID_HEADER, channelId).setHeader("Accept", "application/vnd.urbanairship+json; version=3;").execute();
    }

    Response<UserCredentials> createUser(@NonNull String channelId) throws RequestException {
        Uri url = this.getUserApiUrl(this.runtimeConfig.getUrlConfig(), new String[0]);
        String payload = this.createNewUserPayload(channelId);
        Logger.verbose((String)"Creating Rich Push user with payload: %s", (Object[])new Object[]{payload});
        return this.requestFactory.createRequest().setOperation("POST", url).setCredentials(this.runtimeConfig.getConfigOptions().appKey, this.runtimeConfig.getConfigOptions().appSecret).setRequestBody(payload, "application/json").setAirshipJsonAcceptsHeader().setAirshipUserAgent(this.runtimeConfig).execute((ResponseParser)new ResponseParser<UserCredentials>(){

            public UserCredentials parseResponse(int status, @Nullable Map<String, List<String>> headers, @Nullable String responseBody) throws Exception {
                if (!UAHttpStatusUtil.inSuccessRange((int)status)) {
                    return null;
                }
                JsonMap credentials = JsonValue.parseString((String)responseBody).getMap();
                if (credentials == null) {
                    throw new JsonException("InboxApiClient - Invalid response, missing credentials.");
                }
                String userId = credentials.opt("user_id").getString();
                String userToken = credentials.opt("password").getString();
                if (UAStringUtil.isEmpty((String)userId) || UAStringUtil.isEmpty((String)userToken)) {
                    throw new JsonException("InboxApiClient - Invalid response, missing credentials.");
                }
                return new UserCredentials(userId, userToken);
            }
        });
    }

    Response<Void> updateUser(@NonNull User user, @NonNull String channelId) throws RequestException {
        Uri url = this.getUserApiUrl(this.runtimeConfig.getUrlConfig(), user.getId());
        String payload = this.createUpdateUserPayload(channelId);
        Logger.verbose((String)"Updating user with payload: %s", (Object[])new Object[]{payload});
        return this.requestFactory.createRequest().setOperation("POST", url).setCredentials(user.getId(), user.getPassword()).setRequestBody(payload, "application/json").setAirshipJsonAcceptsHeader().setAirshipUserAgent(this.runtimeConfig).execute();
    }

    @Nullable
    private Uri getUserApiUrl(@NonNull AirshipUrlConfig urlConfig, String ... paths) {
        UrlBuilder builder = urlConfig.deviceUrl().appendEncodedPath(USER_API_PATH);
        for (String path : paths) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            builder.appendEncodedPath(path);
        }
        return builder.build();
    }

    private String createNewUserPayload(@NonNull String channelId) throws RequestException {
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put(this.getPayloadChannelsKey(), Collections.singletonList(channelId));
        return JsonValue.wrapOpt(payload).toString();
    }

    private String createUpdateUserPayload(@NonNull String channelId) throws RequestException {
        HashMap<String, List<String>> addChannels = new HashMap<String, List<String>>();
        addChannels.put(PAYLOAD_ADD_KEY, Collections.singletonList(channelId));
        HashMap<String, HashMap<String, List<String>>> payload = new HashMap<String, HashMap<String, List<String>>>();
        payload.put(this.getPayloadChannelsKey(), addChannels);
        return JsonValue.wrapOpt(payload).toString();
    }

    @NonNull
    private String getPayloadChannelsKey() throws RequestException {
        switch (this.runtimeConfig.getPlatform()) {
            case 1: {
                return PAYLOAD_AMAZON_CHANNELS_KEY;
            }
            case 2: {
                return PAYLOAD_ANDROID_CHANNELS_KEY;
            }
        }
        throw new RequestException("Invalid platform");
    }
}

