/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.util.DateUtils;
import com.urbanairship.util.UAStringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Message
implements Comparable<Message> {
    static final String MESSAGE_EXPIRY_KEY = "message_expiry";
    static final String MESSAGE_ID_KEY = "message_id";
    static final String MESSAGE_URL_KEY = "message_url";
    static final String MESSAGE_BODY_URL_KEY = "message_body_url";
    static final String MESSAGE_READ_URL_KEY = "message_read_url";
    static final String MESSAGE_SENT_KEY = "message_sent";
    static final String MESSAGE_REPORTING_KEY = "message_reporting";
    static final String EXTRA_KEY = "extra";
    static final String TITLE_KEY = "title";
    static final String UNREAD_KEY = "unread";
    private boolean unreadOrigin;
    private Map<String, String> extrasMap;
    private long sentMS;
    private Long expirationMS;
    private String messageId;
    private String messageUrl;
    private String messageBodyUrl;
    private String messageReadUrl;
    private JsonValue messageReporting;
    private String title;
    private JsonValue rawJson;
    boolean deleted = false;
    boolean unreadClient;

    protected Message() {
    }

    @Nullable
    static Message create(@NonNull JsonValue messagePayload, boolean unreadClient, boolean deleted) {
        JsonMap messageMap = messagePayload.getMap();
        if (messageMap == null) {
            return null;
        }
        String messageId = messageMap.opt(MESSAGE_ID_KEY).getString();
        if (messageId == null) {
            return null;
        }
        String messageUrl = messageMap.opt(MESSAGE_URL_KEY).getString();
        if (messageUrl == null) {
            return null;
        }
        String messageBodyUrl = messageMap.opt(MESSAGE_BODY_URL_KEY).getString();
        if (messageBodyUrl == null) {
            return null;
        }
        String messageReadUrl = messageMap.opt(MESSAGE_READ_URL_KEY).getString();
        if (messageReadUrl == null) {
            return null;
        }
        JsonValue messageReporting = messageMap.get(MESSAGE_REPORTING_KEY);
        Message message = new Message();
        message.messageId = messageId;
        message.messageUrl = messageUrl;
        message.messageBodyUrl = messageBodyUrl;
        message.messageReadUrl = messageReadUrl;
        message.messageReporting = messageReporting;
        message.title = messageMap.opt(TITLE_KEY).optString();
        message.unreadOrigin = messageMap.opt(UNREAD_KEY).getBoolean(true);
        message.rawJson = messagePayload;
        String sentMS = messageMap.opt(MESSAGE_SENT_KEY).getString();
        message.sentMS = UAStringUtil.isEmpty((String)sentMS) ? System.currentTimeMillis() : DateUtils.parseIso8601((String)sentMS, (long)System.currentTimeMillis());
        String messageExpiry = messageMap.opt(MESSAGE_EXPIRY_KEY).getString();
        if (!UAStringUtil.isEmpty((String)messageExpiry)) {
            message.expirationMS = DateUtils.parseIso8601((String)messageExpiry, (long)Long.MAX_VALUE);
        }
        HashMap<String, String> extrasMap = new HashMap<String, String>();
        for (Map.Entry entry : messageMap.opt(EXTRA_KEY).optMap()) {
            if (((JsonValue)entry.getValue()).isString()) {
                extrasMap.put((String)entry.getKey(), ((JsonValue)entry.getValue()).getString());
                continue;
            }
            extrasMap.put((String)entry.getKey(), ((JsonValue)entry.getValue()).toString());
        }
        message.extrasMap = extrasMap;
        message.deleted = deleted;
        message.unreadClient = unreadClient;
        return message;
    }

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    @NonNull
    public String getMessageUrl() {
        return this.messageUrl;
    }

    @NonNull
    public String getMessageBodyUrl() {
        return this.messageBodyUrl;
    }

    @NonNull
    public String getMessageReadUrl() {
        return this.messageReadUrl;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JsonValue getMessageReporting() {
        return this.messageReporting;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public boolean isRead() {
        return !this.unreadClient;
    }

    @NonNull
    public Date getSentDate() {
        return new Date(this.sentMS);
    }

    public long getSentDateMS() {
        return this.sentMS;
    }

    @Nullable
    public Date getExpirationDate() {
        if (this.expirationMS != null) {
            return new Date(this.expirationMS);
        }
        return null;
    }

    @Nullable
    public Long getExpirationDateMS() {
        return this.expirationMS;
    }

    public boolean isExpired() {
        return this.expirationMS != null && System.currentTimeMillis() >= this.expirationMS;
    }

    @NonNull
    public Bundle getExtras() {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : this.extrasMap.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    @NonNull
    public Map<String, String> getExtrasMap() {
        return this.extrasMap;
    }

    public void markRead() {
        if (this.unreadClient) {
            this.unreadClient = false;
            HashSet<String> set = new HashSet<String>();
            set.add(this.messageId);
            MessageCenter.shared().getInbox().markMessagesRead(set);
        }
    }

    public void markUnread() {
        if (!this.unreadClient) {
            this.unreadClient = true;
            HashSet<String> set = new HashSet<String>();
            set.add(this.messageId);
            MessageCenter.shared().getInbox().markMessagesUnread(set);
        }
    }

    public void delete() {
        if (!this.deleted) {
            this.deleted = true;
            HashSet<String> set = new HashSet<String>();
            set.add(this.messageId);
            MessageCenter.shared().getInbox().deleteMessages(set);
        }
    }

    @NonNull
    public JsonValue getRawMessageJson() {
        return this.rawJson;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Nullable
    public String getListIconUrl() {
        JsonValue icons = this.getRawMessageJson().optMap().opt("icons");
        if (icons.isJsonMap()) {
            return icons.optMap().opt("list_icon").getString();
        }
        return null;
    }

    @Override
    public int compareTo(@NonNull Message another) {
        return this.getMessageId().compareTo(another.getMessageId());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        if (this == that) {
            return true;
        }
        return (this.messageId == null ? that.messageId == null : this.messageId.equals(that.messageId)) && (this.messageBodyUrl == null ? that.messageBodyUrl == null : this.messageBodyUrl.equals(that.messageBodyUrl)) && (this.messageReadUrl == null ? that.messageReadUrl == null : this.messageReadUrl.equals(that.messageReadUrl)) && (this.messageUrl == null ? that.messageUrl == null : this.messageUrl.equals(that.messageUrl)) && (this.extrasMap == null ? that.extrasMap == null : this.extrasMap.equals(that.extrasMap)) && this.unreadClient == that.unreadClient && this.unreadOrigin == that.unreadOrigin && this.deleted == that.deleted && this.sentMS == that.sentMS;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 37 * result + (this.messageBodyUrl == null ? 0 : this.messageBodyUrl.hashCode());
        result = 37 * result + (this.messageReadUrl == null ? 0 : this.messageReadUrl.hashCode());
        result = 37 * result + (this.messageUrl == null ? 0 : this.messageUrl.hashCode());
        result = 37 * result + (this.extrasMap == null ? 0 : this.extrasMap.hashCode());
        result = 37 * result + (this.unreadClient ? 0 : 1);
        result = 37 * result + (this.unreadOrigin ? 0 : 1);
        result = 37 * result + (this.deleted ? 0 : 1);
        result = 37 * result + Long.valueOf(this.sentMS).hashCode();
        return result;
    }
}

