/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.urbanairship.analytics.data.BatchedQueryHelper;
import com.urbanairship.messagecenter.MessageEntity;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Dao
public abstract class MessageDao {
    @Insert(onConflict=1)
    public abstract void insert(@NonNull MessageEntity var1);

    @Transaction
    @Query(value="SELECT * FROM richpush")
    @NonNull
    public abstract List<MessageEntity> getMessages();

    @Transaction
    @Query(value="SELECT message_id FROM richpush")
    @NonNull
    public abstract List<String> getMessageIds();

    @Transaction
    @Query(value="SELECT * FROM richpush WHERE unread = 0 AND unread <> unread_orig")
    @NonNull
    public abstract List<MessageEntity> getLocallyReadMessages();

    @Transaction
    @Query(value="SELECT * FROM richpush WHERE deleted = 1")
    @NonNull
    public abstract List<MessageEntity> getLocallyDeletedMessages();

    @Transaction
    @Query(value="UPDATE richpush SET unread = 0 WHERE message_id IN (:messageIds)")
    @NonNull
    public abstract void markMessagesRead(@NonNull List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET unread = 1 WHERE message_id IN (:messageIds)")
    @NonNull
    public abstract void markMessagesUnread(@NonNull List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET deleted = 1 WHERE message_id IN (:messageIds)")
    @NonNull
    public abstract void markMessagesDeleted(@NonNull List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET unread_orig = 0 WHERE message_id IN (:messageIds)")
    @NonNull
    public abstract void markMessagesReadOrigin(@NonNull List<String> var1);

    @Transaction
    @NonNull
    public void deleteMessages(@NonNull List<String> messageIds) {
        Consumer consumer = ids -> this.deleteMessagesBatch((List<String>)ids);
        BatchedQueryHelper.runBatched(messageIds, (Consumer)consumer);
    }

    @Query(value="DELETE FROM richpush WHERE message_id IN (:messageIds)")
    abstract void deleteMessagesBatch(@NonNull List<String> var1);

    @Transaction
    @Query(value="DELETE FROM richpush")
    @NonNull
    public abstract void deleteAllMessages();

    @Insert(onConflict=1)
    @NonNull
    public abstract void insertMessages(@NonNull List<MessageEntity> var1);

    @Update(onConflict=1)
    @NonNull
    public abstract int updateMessage(@NonNull MessageEntity var1);

    @Query(value="DELETE FROM richpush WHERE _id NOT IN (SELECT MIN(_id) FROM richpush GROUP BY message_id)")
    @NonNull
    public abstract void deleteDuplicates();

    @Query(value="SELECT EXISTS (SELECT 1 FROM richpush WHERE message_id = :id)")
    @NonNull
    public abstract boolean messageExists(@NonNull String var1);
}

