/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.urbanairship.AirshipConfigOptions;
import com.urbanairship.messagecenter.MessageDao;
import com.urbanairship.messagecenter.MessageEntity;
import java.io.File;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Database(entities={MessageEntity.class}, version=2)
public abstract class MessageDatabase
extends RoomDatabase {
    private static final String DATABASE_DIRECTORY_NAME = "com.urbanairship.databases";
    static final String DATABASE_NAME = "ua_richpush.db";
    static final String TABLE_NAME = "richpush";
    static final String NEW_TABLE_NAME = "richpush_new";
    static final String COLUMN_NAME_KEY = "_id";
    static final String COLUMN_NAME_MESSAGE_ID = "message_id";
    static final String COLUMN_NAME_MESSAGE_URL = "message_url";
    static final String COLUMN_NAME_MESSAGE_BODY_URL = "message_body_url";
    static final String COLUMN_NAME_MESSAGE_READ_URL = "message_read_url";
    static final String COLUMN_NAME_TITLE = "title";
    static final String COLUMN_NAME_EXTRA = "extra";
    static final String COLUMN_NAME_UNREAD = "unread";
    static final String COLUMN_NAME_UNREAD_ORIG = "unread_orig";
    static final String COLUMN_NAME_DELETED = "deleted";
    static final String COLUMN_NAME_TIMESTAMP = "timestamp";
    static final String COLUMN_NAME_RAW_MESSAGE_OBJECT = "raw_message_object";
    static final String COLUMN_NAME_EXPIRATION_TIMESTAMP = "expiration_timestamp";
    static final int DATABASE_VERSION = 2;
    static final Migration MIGRATION_1_2 = new Migration(1, 2){

        public void migrate(@NonNull SupportSQLiteDatabase db) {
            db.execSQL("CREATE TABLE richpush_new (_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, message_id TEXT UNIQUE, message_url TEXT, message_body_url TEXT, message_read_url TEXT, title TEXT, extra TEXT, unread INTEGER, unread_orig INTEGER, deleted INTEGER, timestamp TEXT, raw_message_object TEXT, expiration_timestamp TEXT );");
            db.execSQL("INSERT INTO richpush_new (_id, message_id, message_url, message_body_url, message_read_url, title, extra, unread, unread_orig, deleted, timestamp, raw_message_object, expiration_timestamp) SELECT _id, message_id, message_url, message_body_url, message_read_url, title, extra, unread, unread_orig, deleted, timestamp, raw_message_object, expiration_timestamp FROM richpush");
            db.execSQL("DROP TABLE richpush");
            db.execSQL("ALTER TABLE richpush_new RENAME TO richpush");
        }
    };

    public abstract MessageDao getDao();

    public static MessageDatabase createDatabase(@NonNull Context context, @NonNull AirshipConfigOptions config) {
        String name = config.appKey + "_" + DATABASE_NAME;
        File urbanAirshipNoBackupDirectory = new File(ContextCompat.getNoBackupFilesDir((Context)context), DATABASE_DIRECTORY_NAME);
        String path = new File(urbanAirshipNoBackupDirectory, name).getAbsolutePath();
        return (MessageDatabase)Room.databaseBuilder((Context)context, MessageDatabase.class, (String)path).addMigrations(new Migration[]{MIGRATION_1_2}).fallbackToDestructiveMigrationOnDowngrade().build();
    }

    @VisibleForTesting
    public static MessageDatabase createInMemoryDatabase(@NonNull Context context) {
        return (MessageDatabase)Room.inMemoryDatabaseBuilder((Context)context, MessageDatabase.class).allowMainThreadQueries().build();
    }

    public boolean exists(@NonNull Context context) {
        return this.getOpenHelper().getDatabaseName() == null || context.getDatabasePath(this.getOpenHelper().getDatabaseName()).exists();
    }
}

