/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.urbanairship.Logger;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.util.DateUtils;
import com.urbanairship.util.UAStringUtil;
import java.util.ArrayList;
import java.util.List;

@Entity(tableName="richpush")
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MessageEntity {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="_id")
    @NonNull
    protected int id;
    @ColumnInfo(name="message_id")
    public String messageId;
    @ColumnInfo(name="message_url")
    public String messageUrl;
    @ColumnInfo(name="message_body_url")
    public String messageBodyUrl;
    @ColumnInfo(name="message_read_url")
    public String messageReadUrl;
    public String title;
    public String extra;
    public boolean unread;
    @ColumnInfo(name="unread_orig")
    public boolean unreadOrig;
    public boolean deleted;
    public String timestamp;
    @ColumnInfo(name="raw_message_object")
    public String rawMessageObject;
    @ColumnInfo(name="expiration_timestamp")
    public String expirationTimestamp;

    public MessageEntity(String messageId, String messageUrl, String messageBodyUrl, String messageReadUrl, String title, String extra, boolean unread, boolean unreadOrig, boolean deleted, String timestamp, String rawMessageObject, String expirationTimestamp) {
        this.messageId = messageId;
        this.messageUrl = messageUrl;
        this.messageBodyUrl = messageBodyUrl;
        this.messageReadUrl = messageReadUrl;
        this.title = title;
        this.extra = extra;
        this.unread = unread;
        this.unreadOrig = unreadOrig;
        this.deleted = deleted;
        this.timestamp = timestamp;
        this.rawMessageObject = rawMessageObject;
        this.expirationTimestamp = expirationTimestamp;
    }

    protected static MessageEntity createMessageFromPayload(@Nullable String messageId, @NonNull JsonValue messagePayload) {
        if (messagePayload == null || !messagePayload.isJsonMap()) {
            Logger.error((String)"RichPushResolver - Unexpected message: %s", (Object[])new Object[]{messagePayload});
            return null;
        }
        JsonMap messageMap = messagePayload.optMap();
        if (UAStringUtil.isEmpty((String)messageMap.opt("message_id").getString())) {
            Logger.error((String)"RichPushResolver - Message is missing an ID: %s", (Object[])new Object[]{messagePayload});
            return null;
        }
        return new MessageEntity(messageId != null ? messageId : messageMap.opt("message_id").getString(), messageMap.opt("message_url").getString(), messageMap.opt("message_body_url").getString(), messageMap.opt("message_read_url").getString(), messageMap.opt("title").getString(), messageMap.opt("extra").getString(), messageMap.opt("unread").getBoolean(true), messageMap.opt("unread").getBoolean(true), false, messageMap.opt("message_sent").getString(), messageMap.toString(), messageMap.containsKey("message_expiry") ? messageMap.opt("message_expiry").getString() : null);
    }

    protected static List<MessageEntity> createMessagesFromPayload(@Nullable List<String> messageIds, @NonNull List<JsonValue> messagePayloads) {
        ArrayList<MessageEntity> messageEntities = new ArrayList<MessageEntity>();
        if (messageIds == null) {
            for (JsonValue messagePayload : messagePayloads) {
                MessageEntity messageEntity = MessageEntity.createMessageFromPayload(null, messagePayload);
                if (messageEntity == null) continue;
                messageEntities.add(messageEntity);
            }
            return messageEntities;
        }
        for (int i = 0; i < messageIds.size(); ++i) {
            MessageEntity messageEntity = MessageEntity.createMessageFromPayload(messageIds.get(i), messagePayloads.get(i));
            if (messageEntity == null) continue;
            messageEntities.add(messageEntity);
        }
        return messageEntities;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getMessageBodyUrl() {
        return this.messageBodyUrl;
    }

    protected JsonValue getMessageReporting() {
        JsonMap messageMap = null;
        try {
            messageMap = JsonValue.parseString((String)this.rawMessageObject).getMap();
        }
        catch (JsonException e) {
            Logger.error((Throwable)e, (String)"MessageEntity - Failed to parse Message reporting.", (Object[])new Object[0]);
        }
        return messageMap.get("message_reporting");
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isExpired() {
        long expirationMS = DateUtils.parseIso8601((String)this.expirationTimestamp, (long)Long.MAX_VALUE);
        return this.expirationTimestamp != null && System.currentTimeMillis() >= expirationMS;
    }

    protected Message createMessageFromEntity(MessageEntity entity) {
        try {
            return Message.create(JsonValue.parseString((String)entity.rawMessageObject), entity.unread, entity.deleted);
        }
        catch (JsonException e) {
            Logger.error((String)"Failed to create Message from JSON", (Object[])new Object[0]);
            return null;
        }
    }
}

