/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.messagecenter.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class MessageViewAdapter
extends BaseAdapter {
    private final List<Message> items;
    private final Context context;
    private final int layout;

    public MessageViewAdapter(@NonNull Context context, int layout2) {
        this.context = context;
        this.layout = layout2;
        this.items = new ArrayList<Message>();
    }

    public int getCount() {
        return this.items.size();
    }

    @Nullable
    public Object getItem(int position) {
        if (position >= this.items.size() || position < 0) {
            return null;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        if (position >= this.items.size() || position < 0) {
            return -1L;
        }
        return this.items.get(position).getMessageId().hashCode();
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @Nullable ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
            view = layoutInflater.inflate(this.layout, parent, false);
        }
        if (position < this.items.size() && position >= 0) {
            this.bindView(view, this.items.get(position), position);
        }
        return view;
    }

    protected abstract void bindView(@NonNull View var1, @NonNull Message var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NonNull Collection<Message> collection) {
        List<Message> list = this.items;
        synchronized (list) {
            this.items.clear();
            this.items.addAll(collection);
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    protected Context getContext() {
        return this.context;
    }

    public boolean hasStableIds() {
        return true;
    }
}

