/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.urbanairship.AirshipConfigOptions;
import com.urbanairship.AirshipExecutors;
import com.urbanairship.Cancelable;
import com.urbanairship.CancelableOperation;
import com.urbanairship.Predicate;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.PrivacyManager;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.app.ApplicationListener;
import com.urbanairship.app.GlobalActivityMonitor;
import com.urbanairship.channel.AirshipChannel;
import com.urbanairship.channel.AirshipChannelListener;
import com.urbanairship.channel.ChannelRegistrationPayload;
import com.urbanairship.job.JobDispatcher;
import com.urbanairship.job.JobInfo;
import com.urbanairship.job.JobResult;
import com.urbanairship.json.JsonMap;
import com.urbanairship.messagecenter.InboxJobHandler;
import com.urbanairship.messagecenter.InboxListener;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageDao;
import com.urbanairship.messagecenter.MessageDatabase;
import com.urbanairship.messagecenter.MessageEntity;
import com.urbanairship.messagecenter.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class Inbox {
    private static final SentAtRichPushMessageComparator MESSAGE_COMPARATOR = new SentAtRichPushMessageComparator();
    private static final Object inboxLock = new Object();
    private final List<InboxListener> listeners = new CopyOnWriteArrayList<InboxListener>();
    private final Set<String> deletedMessageIds = new HashSet<String>();
    private final Map<String, Message> unreadMessages = new HashMap<String, Message>();
    private final Map<String, Message> readMessages = new HashMap<String, Message>();
    private final Map<String, Message> messageUrlMap = new HashMap<String, Message>();
    private final MessageDao messageDao;
    private final User user;
    private final Executor executor;
    private final Context context;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final PreferenceDataStore dataStore;
    private final JobDispatcher jobDispatcher;
    private final ApplicationListener applicationListener;
    private final AirshipChannelListener channelListener;
    private final AirshipChannel.Extender channelRegistrationPayloadExtender;
    private final User.Listener userListener;
    private final ActivityMonitor activityMonitor;
    private final AirshipChannel airshipChannel;
    private boolean isFetchingMessages = false;
    @Nullable
    @VisibleForTesting
    InboxJobHandler inboxJobHandler;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final List<PendingFetchMessagesCallback> pendingFetchCallbacks = new ArrayList<PendingFetchMessagesCallback>();

    public Inbox(@NonNull Context context, @NonNull PreferenceDataStore dataStore, @NonNull AirshipChannel airshipChannel, @NonNull AirshipConfigOptions configOptions, @NonNull PrivacyManager privacyManager) {
        this(context, dataStore, JobDispatcher.shared((Context)context), new User(dataStore, airshipChannel), MessageDatabase.createDatabase(context, configOptions).getDao(), AirshipExecutors.newSerialExecutor(), (ActivityMonitor)GlobalActivityMonitor.shared((Context)context), airshipChannel, privacyManager);
    }

    @VisibleForTesting
    Inbox(@NonNull Context context, @NonNull PreferenceDataStore dataStore, final @NonNull JobDispatcher jobDispatcher, @NonNull User user, @NonNull MessageDao messageDao, @NonNull Executor executor, @NonNull ActivityMonitor activityMonitor, @NonNull AirshipChannel airshipChannel, final @NonNull PrivacyManager privacyManager) {
        this.context = context.getApplicationContext();
        this.dataStore = dataStore;
        this.user = user;
        this.messageDao = messageDao;
        this.executor = executor;
        this.jobDispatcher = jobDispatcher;
        this.airshipChannel = airshipChannel;
        this.applicationListener = new ApplicationListener(){

            public void onForeground(long time) {
                JobInfo jobInfo = JobInfo.newBuilder().setAction("ACTION_RICH_PUSH_MESSAGES_UPDATE").setAirshipComponent(MessageCenter.class).setConflictStrategy(2).build();
                jobDispatcher.dispatch(jobInfo);
            }

            public void onBackground(long time) {
                JobInfo jobInfo = JobInfo.newBuilder().setAction("ACTION_SYNC_MESSAGE_STATE").setAirshipComponent(MessageCenter.class).setConflictStrategy(2).build();
                jobDispatcher.dispatch(jobInfo);
            }
        };
        this.channelListener = channelId -> this.dispatchUpdateUserJob(true);
        this.channelRegistrationPayloadExtender = new AirshipChannel.Extender.Blocking(){

            @NonNull
            public ChannelRegistrationPayload.Builder extend(@NonNull ChannelRegistrationPayload.Builder builder) {
                if (privacyManager.isEnabled(new int[]{2})) {
                    return builder.setUserId(Inbox.this.getUser().getId());
                }
                return builder;
            }
        };
        this.userListener = success -> {
            if (success) {
                this.fetchMessages();
            }
        };
        this.activityMonitor = activityMonitor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void init() {
        this.updateEnabledState();
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    JobResult onPerformJob(@NonNull UAirship airship, @NonNull JobInfo jobInfo) {
        if (!this.isEnabled.get()) {
            return JobResult.SUCCESS;
        }
        if (this.inboxJobHandler == null) {
            this.inboxJobHandler = new InboxJobHandler(this.context, this, this.getUser(), this.airshipChannel, airship.getRuntimeConfig(), this.dataStore, this.messageDao);
        }
        return this.inboxJobHandler.performJob(jobInfo);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void updateEnabledState() {
        if (this.isEnabled.get()) {
            if (!this.isStarted.getAndSet(true)) {
                this.user.addListener(this.userListener);
                this.refresh(false);
                this.activityMonitor.addApplicationListener(this.applicationListener);
                this.airshipChannel.addChannelListener(this.channelListener);
                if (this.user.shouldUpdate()) {
                    this.dispatchUpdateUserJob(true);
                }
                this.airshipChannel.addChannelRegistrationPayloadExtender(this.channelRegistrationPayloadExtender);
            }
        } else {
            this.deleteAllMessages();
            InboxJobHandler jobHandler = this.inboxJobHandler;
            if (jobHandler != null) {
                jobHandler.removeStoredData();
            }
            this.tearDown();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void tearDown() {
        this.activityMonitor.removeApplicationListener(this.applicationListener);
        this.airshipChannel.removeChannelListener(this.channelListener);
        this.airshipChannel.removeChannelRegistrationPayloadExtender(this.channelRegistrationPayloadExtender);
        this.user.removeListener(this.userListener);
        this.isStarted.set(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    @NonNull
    public User getUser() {
        return this.user;
    }

    public void addListener(@NonNull InboxListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull InboxListener listener) {
        this.listeners.remove(listener);
    }

    public void fetchMessages() {
        this.fetchMessages(null, null);
    }

    @Nullable
    public Cancelable fetchMessages(@Nullable FetchMessagesCallback callback) {
        return this.fetchMessages(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cancelable fetchMessages(@Nullable Looper looper, @Nullable FetchMessagesCallback callback) {
        PendingFetchMessagesCallback cancelableOperation = new PendingFetchMessagesCallback(callback, looper);
        List<PendingFetchMessagesCallback> list = this.pendingFetchCallbacks;
        synchronized (list) {
            this.pendingFetchCallbacks.add(cancelableOperation);
            if (!this.isFetchingMessages) {
                JobInfo jobInfo = JobInfo.newBuilder().setAction("ACTION_RICH_PUSH_MESSAGES_UPDATE").setAirshipComponent(MessageCenter.class).setConflictStrategy(0).build();
                this.jobDispatcher.dispatch(jobInfo);
            }
            this.isFetchingMessages = true;
        }
        return cancelableOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUpdateMessagesFinished(boolean result) {
        List<PendingFetchMessagesCallback> list = this.pendingFetchCallbacks;
        synchronized (list) {
            for (PendingFetchMessagesCallback callback : this.pendingFetchCallbacks) {
                callback.result = result;
                callback.run();
            }
            this.isFetchingMessages = false;
            this.pendingFetchCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = inboxLock;
        synchronized (object) {
            return this.unreadMessages.size() + this.readMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<String> getMessageIds() {
        Object object = inboxLock;
        synchronized (object) {
            HashSet<String> messageIds = new HashSet<String>(this.getCount());
            messageIds.addAll(this.readMessages.keySet());
            messageIds.addAll(this.unreadMessages.keySet());
            return messageIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadCount() {
        Object object = inboxLock;
        synchronized (object) {
            return this.readMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadCount() {
        Object object = inboxLock;
        synchronized (object) {
            return this.unreadMessages.size();
        }
    }

    @NonNull
    private Collection<Message> filterMessages(@NonNull Collection<Message> messages, @Nullable Predicate<Message> predicate) {
        ArrayList<Message> filteredMessages = new ArrayList<Message>();
        if (predicate == null) {
            return messages;
        }
        for (Message message : messages) {
            if (!predicate.apply((Object)message)) continue;
            filteredMessages.add(message);
        }
        return filteredMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Message> getMessages(@Nullable Predicate<Message> predicate) {
        Object object = inboxLock;
        synchronized (object) {
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.addAll(this.filterMessages(this.unreadMessages.values(), predicate));
            messages.addAll(this.filterMessages(this.readMessages.values(), predicate));
            Collections.sort(messages, MESSAGE_COMPARATOR);
            return messages;
        }
    }

    @NonNull
    public List<Message> getMessages() {
        return this.getMessages(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Message> getUnreadMessages(@Nullable Predicate<Message> predicate) {
        Object object = inboxLock;
        synchronized (object) {
            ArrayList<Message> messages = new ArrayList<Message>(this.filterMessages(this.unreadMessages.values(), predicate));
            Collections.sort(messages, MESSAGE_COMPARATOR);
            return messages;
        }
    }

    @NonNull
    public List<Message> getUnreadMessages() {
        return this.getUnreadMessages(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Message> getReadMessages(@Nullable Predicate<Message> predicate) {
        Object object = inboxLock;
        synchronized (object) {
            ArrayList<Message> messages = new ArrayList<Message>(this.filterMessages(this.readMessages.values(), predicate));
            Collections.sort(messages, MESSAGE_COMPARATOR);
            return messages;
        }
    }

    @NonNull
    public List<Message> getReadMessages() {
        return this.getReadMessages(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message getMessage(@Nullable String messageId) {
        if (messageId == null) {
            return null;
        }
        Object object = inboxLock;
        synchronized (object) {
            if (this.unreadMessages.containsKey(messageId)) {
                return this.unreadMessages.get(messageId);
            }
            return this.readMessages.get(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message getMessageByUrl(@Nullable String messageUrl) {
        if (messageUrl == null) {
            return null;
        }
        Object object = inboxLock;
        synchronized (object) {
            return this.messageUrlMap.get(messageUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessagesRead(final @NonNull Set<String> messageIds) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> messageIdsList = new ArrayList<String>(messageIds);
                Inbox.this.messageDao.markMessagesRead(messageIdsList);
            }
        });
        Object object = inboxLock;
        synchronized (object) {
            for (String messageId : messageIds) {
                Message message = this.unreadMessages.get(messageId);
                if (message == null) continue;
                message.unreadClient = false;
                this.unreadMessages.remove(messageId);
                this.readMessages.put(messageId, message);
            }
            this.notifyInboxUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessagesUnread(final @NonNull Set<String> messageIds) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> messageIdsList = new ArrayList<String>(messageIds);
                Inbox.this.messageDao.markMessagesUnread(messageIdsList);
            }
        });
        Object object = inboxLock;
        synchronized (object) {
            for (String messageId : messageIds) {
                Message message = this.readMessages.get(messageId);
                if (message == null) continue;
                message.unreadClient = true;
                this.readMessages.remove(messageId);
                this.unreadMessages.put(messageId, message);
            }
        }
        this.notifyInboxUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessages(final @NonNull Set<String> messageIds) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> messageIdsList = new ArrayList<String>(messageIds);
                Inbox.this.messageDao.markMessagesDeleted(messageIdsList);
            }
        });
        Object object = inboxLock;
        synchronized (object) {
            for (String messageId : messageIds) {
                Message message = this.getMessage(messageId);
                if (message == null) continue;
                message.deleted = true;
                this.unreadMessages.remove(messageId);
                this.readMessages.remove(messageId);
                this.deletedMessageIds.add(messageId);
            }
        }
        this.notifyInboxUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllMessages() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Inbox.this.messageDao.deleteAllMessages();
            }
        });
        Object object = inboxLock;
        synchronized (object) {
            this.unreadMessages.clear();
            this.readMessages.clear();
            this.deletedMessageIds.clear();
        }
        this.notifyInboxUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean notify) {
        List<MessageEntity> messageList = this.messageDao.getMessages();
        Object object = inboxLock;
        synchronized (object) {
            HashSet<String> previousUnreadMessageIds = new HashSet<String>(this.unreadMessages.keySet());
            HashSet<String> previousReadMessageIds = new HashSet<String>(this.readMessages.keySet());
            HashSet<String> previousDeletedMessageIds = new HashSet<String>(this.deletedMessageIds);
            this.unreadMessages.clear();
            this.readMessages.clear();
            this.messageUrlMap.clear();
            for (MessageEntity messageEntity : messageList) {
                Message message = messageEntity.createMessageFromEntity(messageEntity);
                if (message == null) continue;
                if (message.isDeleted() || previousDeletedMessageIds.contains(message.getMessageId())) {
                    this.deletedMessageIds.add(message.getMessageId());
                    continue;
                }
                if (message.isExpired()) {
                    this.deletedMessageIds.add(message.getMessageId());
                    continue;
                }
                this.messageUrlMap.put(message.getMessageBodyUrl(), message);
                if (previousUnreadMessageIds.contains(message.getMessageId())) {
                    message.unreadClient = true;
                    this.unreadMessages.put(message.getMessageId(), message);
                    continue;
                }
                if (previousReadMessageIds.contains(message.getMessageId())) {
                    message.unreadClient = false;
                    this.readMessages.put(message.getMessageId(), message);
                    continue;
                }
                if (message.unreadClient) {
                    this.unreadMessages.put(message.getMessageId(), message);
                    continue;
                }
                this.readMessages.put(message.getMessageId(), message);
            }
        }
        if (notify) {
            this.notifyInboxUpdated();
        }
    }

    private void notifyInboxUpdated() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (InboxListener listener : Inbox.this.listeners) {
                    listener.onInboxUpdated();
                }
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void dispatchUpdateUserJob(boolean forcefully) {
        UALog.d((String)"Updating user.", (Object[])new Object[0]);
        JobInfo jobInfo = JobInfo.newBuilder().setAction("ACTION_RICH_PUSH_USER_UPDATE").setAirshipComponent(MessageCenter.class).setExtras(JsonMap.newBuilder().put("EXTRA_FORCEFULLY", forcefully).build()).setConflictStrategy(forcefully ? 0 : 2).build();
        this.jobDispatcher.dispatch(jobInfo);
    }

    static class PendingFetchMessagesCallback
    extends CancelableOperation {
        private final FetchMessagesCallback callback;
        boolean result;

        PendingFetchMessagesCallback(FetchMessagesCallback callback, Looper looper) {
            super(looper);
            this.callback = callback;
        }

        protected void onRun() {
            if (this.callback != null) {
                this.callback.onFinished(this.result);
            }
        }
    }

    static class SentAtRichPushMessageComparator
    implements Comparator<Message> {
        SentAtRichPushMessageComparator() {
        }

        @Override
        public int compare(@NonNull Message lhs, @NonNull Message rhs) {
            if (rhs.getSentDateMS() == lhs.getSentDateMS()) {
                return lhs.getMessageId().compareTo(rhs.getMessageId());
            }
            return Long.compare(rhs.getSentDateMS(), lhs.getSentDateMS());
        }
    }

    public static interface FetchMessagesCallback {
        public void onFinished(boolean var1);
    }
}

