/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.UALog;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.config.UrlBuilder;
import com.urbanairship.http.Request;
import com.urbanairship.http.RequestAuth;
import com.urbanairship.http.RequestBody;
import com.urbanairship.http.RequestException;
import com.urbanairship.http.RequestSession;
import com.urbanairship.http.Response;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.User;
import com.urbanairship.messagecenter.UserCredentials;
import com.urbanairship.util.UAHttpStatusUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class InboxApiClient {
    private static final String USER_API_PATH = "api/user/";
    private static final String DELETE_MESSAGES_PATH = "messages/delete/";
    private static final String MARK_READ_MESSAGES_PATH = "messages/unread/";
    private static final String MESSAGES_PATH = "messages/";
    private static final String MESSAGES_REPORTINGS_KEY = "messages";
    private static final String CHANNEL_ID_HEADER = "X-UA-Channel-ID";
    private static final String PAYLOAD_AMAZON_CHANNELS_KEY = "amazon_channels";
    private static final String PAYLOAD_ANDROID_CHANNELS_KEY = "android_channels";
    private static final String PAYLOAD_ADD_KEY = "add";
    private final AirshipRuntimeConfig runtimeConfig;
    private final RequestSession session;

    InboxApiClient(@NonNull AirshipRuntimeConfig runtimeConfig) {
        this(runtimeConfig, runtimeConfig.getRequestSession());
    }

    InboxApiClient(@NonNull AirshipRuntimeConfig runtimeConfig, @NonNull RequestSession session) {
        this.runtimeConfig = runtimeConfig;
        this.session = session;
    }

    @NonNull
    Response<JsonList> fetchMessages(@NonNull User user, @NonNull String channelId, @Nullable String ifModifiedSince) throws RequestException {
        Uri url = this.getUserApiUrl(user.getId(), MESSAGES_PATH);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3;");
        headers.put(CHANNEL_ID_HEADER, channelId);
        if (ifModifiedSince != null) {
            headers.put("If-Modified-Since", ifModifiedSince);
        }
        Request request = new Request(url, "GET", this.getUserAuth(user), null, headers);
        return this.session.execute(request, (status, responseHeaders, responseBody) -> {
            if (!UAHttpStatusUtil.inSuccessRange((int)status)) {
                return null;
            }
            return JsonValue.parseString((String)responseBody).optMap().opt(MESSAGES_REPORTINGS_KEY).requireList();
        });
    }

    Response<Void> syncDeletedMessageState(@NonNull User user, @NonNull String channelId, @NonNull List<JsonValue> reportingsToDelete) throws RequestException {
        Uri url = this.getUserApiUrl(user.getId(), DELETE_MESSAGES_PATH);
        JsonMap payload = JsonMap.newBuilder().put(MESSAGES_REPORTINGS_KEY, (JsonSerializable)JsonValue.wrapOpt(reportingsToDelete)).build();
        UALog.v((String)"Deleting inbox messages with payload: %s", (Object[])new Object[]{payload});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3;");
        headers.put(CHANNEL_ID_HEADER, channelId);
        Request request = new Request(url, "POST", this.getUserAuth(user), (RequestBody)new RequestBody.Json((JsonSerializable)payload), headers);
        return this.session.execute(request, (status, responseHeaders, responseBody) -> null);
    }

    Response<Void> syncReadMessageState(@NonNull User user, @NonNull String channelId, @NonNull List<JsonValue> reportingsToUpdate) throws RequestException {
        Uri url = this.getUserApiUrl(user.getId(), MARK_READ_MESSAGES_PATH);
        JsonMap payload = JsonMap.newBuilder().put(MESSAGES_REPORTINGS_KEY, (JsonSerializable)JsonValue.wrapOpt(reportingsToUpdate)).build();
        UALog.v((String)"Marking inbox messages read request with payload: %s", (Object[])new Object[]{payload});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3;");
        headers.put(CHANNEL_ID_HEADER, channelId);
        Request request = new Request(url, "POST", this.getUserAuth(user), (RequestBody)new RequestBody.Json((JsonSerializable)payload), headers);
        return this.session.execute(request, (status, responseHeaders, responseBody) -> null);
    }

    Response<UserCredentials> createUser(@NonNull String channelId) throws RequestException {
        Uri url = this.getUserApiUrl(new String[0]);
        JsonMap payload = JsonMap.newBuilder().putOpt(this.getPayloadChannelsKey(), Collections.singletonList(channelId)).build();
        UALog.v((String)"Creating Rich Push user with payload: %s", (Object[])new Object[]{payload});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3;");
        headers.put(CHANNEL_ID_HEADER, channelId);
        Request request = new Request(url, "POST", (RequestAuth)new RequestAuth.ChannelTokenAuth(channelId), (RequestBody)new RequestBody.Json((JsonSerializable)payload), headers);
        return this.session.execute(request, (status, responseHeaders, responseBody) -> {
            if (!UAHttpStatusUtil.inSuccessRange((int)status)) {
                return null;
            }
            JsonMap credentials = JsonValue.parseString((String)responseBody).requireMap();
            String userId = credentials.opt("user_id").requireString();
            String userToken = credentials.opt("password").requireString();
            return new UserCredentials(userId, userToken);
        });
    }

    Response<Void> updateUser(@NonNull User user, @NonNull String channelId) throws RequestException {
        Uri url = this.getUserApiUrl(user.getId());
        JsonMap payload = JsonMap.newBuilder().putOpt(this.getPayloadChannelsKey(), (Object)JsonMap.newBuilder().putOpt(PAYLOAD_ADD_KEY, Collections.singletonList(channelId)).build()).build();
        UALog.v((String)"Updating user with payload: %s", (Object[])new Object[]{payload});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3;");
        headers.put(CHANNEL_ID_HEADER, channelId);
        Request request = new Request(url, "POST", this.getUserAuth(user), (RequestBody)new RequestBody.Json((JsonSerializable)payload), headers);
        return this.session.execute(request, (status, responseHeaders, responseBody) -> null);
    }

    @Nullable
    private Uri getUserApiUrl(String ... paths) {
        UrlBuilder builder = this.runtimeConfig.getDeviceUrl().appendEncodedPath(USER_API_PATH);
        for (String path : paths) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            builder.appendEncodedPath(path);
        }
        return builder.build();
    }

    @NonNull
    private String getPayloadChannelsKey() throws RequestException {
        switch (this.runtimeConfig.getPlatform()) {
            case 1: {
                return PAYLOAD_AMAZON_CHANNELS_KEY;
            }
            case 2: {
                return PAYLOAD_ANDROID_CHANNELS_KEY;
            }
        }
        throw new RequestException("Invalid platform");
    }

    private RequestAuth getUserAuth(@NonNull User user) throws RequestException {
        String userId = user.getId();
        String userPassword = user.getPassword();
        if (userId == null || userPassword == null) {
            throw new RequestException("Missing user credentials");
        }
        return new RequestAuth.BasicAuth(userId, userPassword);
    }
}

