/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.urbanairship.Autopilot;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.activity.ThemedActivity;
import com.urbanairship.messagecenter.InboxListener;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageFragment;

public class MessageActivity
extends ThemedActivity {
    private static final String FRAGMENT_TAG = "MessageFragment";
    private String messageId;
    private final InboxListener updateMessageListener = new InboxListener(){

        @Override
        public void onInboxUpdated() {
            if (MessageActivity.this.messageId != null) {
                MessageActivity.this.updateTitle(MessageActivity.this.messageId);
            }
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Autopilot.automaticTakeOff((Application)this.getApplication());
        if (!UAirship.isTakingOff() && !UAirship.isFlying()) {
            UALog.e((String)"MessageActivity - unable to create activity, takeOff not called.", (Object[])new Object[0]);
            this.finish();
            return;
        }
        this.setDisplayHomeAsUpEnabled(true);
        this.messageId = savedInstanceState == null ? MessageCenter.parseMessageId(this.getIntent()) : savedInstanceState.getString("messageId");
        if (this.messageId == null) {
            this.finish();
            return;
        }
        this.loadMessage();
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("messageId", this.messageId);
    }

    private void loadMessage() {
        if (this.messageId == null) {
            return;
        }
        MessageFragment previousMessageFragment = (MessageFragment)this.getSupportFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (previousMessageFragment == null || !this.messageId.equals(previousMessageFragment.getMessageId())) {
            FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
            if (previousMessageFragment != null) {
                transaction.remove((Fragment)previousMessageFragment);
            }
            transaction.add(0x1020002, (Fragment)MessageFragment.newInstance(this.messageId), FRAGMENT_TAG).commitNow();
        }
        this.updateTitle(this.messageId);
    }

    protected void onStart() {
        super.onStart();
        MessageCenter.shared().getInbox().addListener(this.updateMessageListener);
    }

    protected void onStop() {
        super.onStop();
        MessageCenter.shared().getInbox().removeListener(this.updateMessageListener);
    }

    private void updateTitle(@Nullable String messageId) {
        Message message = MessageCenter.shared().getInbox().getMessage(messageId);
        if (message == null) {
            this.setTitle(null);
        } else {
            this.setTitle(message.getTitle());
        }
    }

    @SuppressLint(value={"UnknownNullness"})
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String newMessageId = MessageCenter.parseMessageId(intent);
        if (newMessageId != null) {
            this.messageId = newMessageId;
            this.loadMessage();
        }
    }

    @SuppressLint(value={"UnknownNullness"})
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return false;
    }
}

