/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.urbanairship.AirshipComponent;
import com.urbanairship.AirshipExecutors;
import com.urbanairship.Predicate;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.PrivacyManager;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.channel.AirshipChannel;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.job.JobInfo;
import com.urbanairship.job.JobResult;
import com.urbanairship.messagecenter.Inbox;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenterActivity;
import com.urbanairship.messagecenter.User;
import com.urbanairship.push.PushListener;
import com.urbanairship.push.PushManager;
import com.urbanairship.util.UAStringUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MessageCenter
extends AirshipComponent {
    @NonNull
    public static final String VIEW_MESSAGE_CENTER_INTENT_ACTION = "com.urbanairship.VIEW_RICH_PUSH_INBOX";
    @NonNull
    public static final String VIEW_MESSAGE_INTENT_ACTION = "com.urbanairship.VIEW_RICH_PUSH_MESSAGE";
    @NonNull
    public static final String MESSAGE_DATA_SCHEME = "message";
    @NonNull
    private static final String DEEP_LINK_HOST = "message_center";
    private Predicate<Message> predicate;
    private final PrivacyManager privacyManager;
    private final PushManager pushManager;
    private final Inbox inbox;
    private OnShowMessageCenterListener onShowMessageCenterListener;
    private final PushListener pushListener;
    private final AirshipRuntimeConfig config;
    private AtomicBoolean isStarted = new AtomicBoolean(false);

    @NonNull
    public static MessageCenter shared() {
        return (MessageCenter)UAirship.shared().requireComponent(MessageCenter.class);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MessageCenter(@NonNull Context context, @NonNull PreferenceDataStore dataStore, @NonNull AirshipRuntimeConfig config, @NonNull PrivacyManager privacyManager, @NonNull AirshipChannel channel, @NonNull PushManager pushManager) {
        this(context, dataStore, config, privacyManager, new Inbox(context, dataStore, channel, config.getConfigOptions(), privacyManager), pushManager);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    MessageCenter(@NonNull Context context, @NonNull PreferenceDataStore dataStore, @NonNull AirshipRuntimeConfig config, @NonNull PrivacyManager privacyManager, @NonNull Inbox inbox, @NonNull PushManager pushManager) {
        super(context, dataStore);
        this.privacyManager = privacyManager;
        this.pushManager = pushManager;
        this.inbox = inbox;
        this.config = config;
        this.pushListener = (message, notificationPosted) -> {
            if (!UAStringUtil.isEmpty((String)message.getRichPushMessageId()) && this.getInbox().getMessage(message.getRichPushMessageId()) == null) {
                UALog.d((String)"Received a Rich Push.", (Object[])new Object[0]);
                this.getInbox().fetchMessages();
            }
        };
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void init() {
        super.init();
        this.privacyManager.addListener(() -> AirshipExecutors.newSerialExecutor().execute(this::updateInboxEnabledState));
        this.config.addConfigListener(() -> this.getInbox().dispatchUpdateUserJob(true));
        this.updateInboxEnabledState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void updateInboxEnabledState() {
        boolean isEnabled = this.privacyManager.isEnabled(new int[]{2});
        this.inbox.setEnabled(isEnabled);
        this.inbox.updateEnabledState();
        if (isEnabled) {
            if (!this.isStarted.getAndSet(true)) {
                UALog.v((String)"Initializing Inbox...", (Object[])new Object[0]);
                this.pushManager.addInternalPushListener(this.pushListener);
            }
        } else {
            this.tearDown();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getComponentGroup() {
        return 2;
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public JobResult onPerformJob(@NonNull UAirship airship, @NonNull JobInfo jobInfo) {
        if (this.privacyManager.isEnabled(new int[]{2})) {
            return this.inbox.onPerformJob(airship, jobInfo);
        }
        return JobResult.SUCCESS;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void tearDown() {
        this.inbox.tearDown();
        this.pushManager.removePushListener(this.pushListener);
        this.isStarted.set(false);
    }

    @NonNull
    public Inbox getInbox() {
        return this.inbox;
    }

    @NonNull
    public User getUser() {
        return this.inbox.getUser();
    }

    @Nullable
    public Predicate<Message> getPredicate() {
        return this.predicate;
    }

    public void setPredicate(@Nullable Predicate<Message> predicate) {
        this.predicate = predicate;
    }

    public void setOnShowMessageCenterListener(@Nullable OnShowMessageCenterListener listener) {
        this.onShowMessageCenterListener = listener;
    }

    public void showMessageCenter() {
        this.showMessageCenter(null);
    }

    public void showMessageCenter(@Nullable String messageId) {
        if (!this.privacyManager.isEnabled(new int[]{2})) {
            UALog.w((String)"Unable to show Message Center. FEATURE_MESSAGE_CENTER is not enabled in PrivacyManager.", (Object[])new Object[0]);
            return;
        }
        OnShowMessageCenterListener listener = this.onShowMessageCenterListener;
        if (listener != null && listener.onShowMessageCenter(messageId)) {
            return;
        }
        Intent intent = new Intent(VIEW_MESSAGE_CENTER_INTENT_ACTION).setPackage(this.getContext().getPackageName()).addFlags(0x30000000);
        if (messageId != null) {
            intent.setData(Uri.fromParts((String)MESSAGE_DATA_SCHEME, (String)messageId, null));
        }
        if (intent.resolveActivity(this.getContext().getPackageManager()) != null) {
            this.getContext().startActivity(intent);
            return;
        }
        if (messageId != null) {
            intent.setAction(VIEW_MESSAGE_INTENT_ACTION);
            if (intent.resolveActivity(this.getContext().getPackageManager()) != null) {
                this.getContext().startActivity(intent);
                return;
            }
        }
        intent.setClass(this.getContext(), MessageCenterActivity.class);
        this.getContext().startActivity(intent);
    }

    @Nullable
    public static String parseMessageId(@Nullable Intent intent) {
        if (intent == null || intent.getData() == null || intent.getAction() == null) {
            return null;
        }
        if (!MESSAGE_DATA_SCHEME.equalsIgnoreCase(intent.getData().getScheme())) {
            return null;
        }
        switch (intent.getAction()) {
            case "com.urbanairship.VIEW_RICH_PUSH_INBOX": 
            case "com.urbanairship.VIEW_RICH_PUSH_MESSAGE": {
                return intent.getData().getSchemeSpecificPart();
            }
        }
        return null;
    }

    public boolean onAirshipDeepLink(@NonNull Uri uri) {
        if (DEEP_LINK_HOST.equals(uri.getEncodedAuthority())) {
            List paths = uri.getPathSegments();
            if (paths.size() == 0) {
                this.showMessageCenter();
                return true;
            }
            if (paths.size() == 1) {
                this.showMessageCenter((String)paths.get(0));
                return true;
            }
        }
        return false;
    }

    public static interface OnShowMessageCenterListener {
        public boolean onShowMessageCenter(@Nullable String var1);
    }
}

