/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.urbanairship.Autopilot;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.activity.ThemedActivity;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageCenterFragment;

public class MessageCenterActivity
extends ThemedActivity {
    private MessageCenterFragment messageCenterFragment;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Autopilot.automaticTakeOff((Application)this.getApplication());
        if (!UAirship.isTakingOff() && !UAirship.isFlying()) {
            UALog.e((String)"MessageCenterActivity - unable to create activity, takeOff not called.", (Object[])new Object[0]);
            this.finish();
            return;
        }
        this.setDisplayHomeAsUpEnabled(true);
        if (savedInstanceState != null) {
            this.messageCenterFragment = (MessageCenterFragment)this.getSupportFragmentManager().findFragmentByTag("MESSAGE_CENTER_FRAGMENT");
        }
        if (this.messageCenterFragment == null) {
            this.messageCenterFragment = MessageCenterFragment.newInstance(MessageCenter.parseMessageId(this.getIntent()));
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)this.messageCenterFragment, "MESSAGE_CENTER_FRAGMENT").commitNow();
        }
        this.messageCenterFragment.setPredicate(MessageCenter.shared().getPredicate());
    }

    protected void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        String messageId = MessageCenter.parseMessageId(intent);
        if (messageId != null) {
            this.messageCenterFragment.setMessageID(messageId);
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return false;
    }
}

