/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.fragment.app.Fragment;
import com.urbanairship.Predicate;
import com.urbanairship.messagecenter.DefaultMultiChoiceModeListener;
import com.urbanairship.messagecenter.InboxListener;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageActivity;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageFragment;
import com.urbanairship.messagecenter.MessageListFragment;
import com.urbanairship.messagecenter.R;
import com.urbanairship.util.ViewUtils;
import java.util.List;

public class MessageCenterFragment
extends Fragment {
    private static final String STATE_CURRENT_MESSAGE_ID = "currentMessageId";
    private static final String STATE_CURRENT_MESSAGE_POSITION = "currentMessagePosition";
    private static final String STATE_ABS_LIST_VIEW = "listView";
    private static final String STATE_PENDING_MESSAGE_ID = "pendingMessageId";
    private Predicate<Message> predicate;
    private MessageListFragment messageListFragment;
    private boolean isTwoPane;
    private boolean isViewConfigured;
    private String currentMessageId;
    private int currentMessagePosition = -1;
    private String pendingMessageId;
    private final InboxListener inboxListener = new InboxListener(){

        @Override
        public void onInboxUpdated() {
            MessageCenterFragment.this.updateCurrentMessage();
        }
    };

    @NonNull
    public static MessageCenterFragment newInstance(@Nullable String messageId) {
        MessageCenterFragment message = new MessageCenterFragment();
        Bundle arguments = new Bundle();
        arguments.putString("messageReporting", messageId);
        message.setArguments(arguments);
        return message;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.currentMessagePosition = savedInstanceState.getInt(STATE_CURRENT_MESSAGE_POSITION, -1);
            this.currentMessageId = savedInstanceState.getString(STATE_CURRENT_MESSAGE_ID, null);
            this.pendingMessageId = savedInstanceState.getString(STATE_PENDING_MESSAGE_ID, null);
        } else if (this.getArguments() != null) {
            this.pendingMessageId = this.getArguments().getString("messageReporting");
        }
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.ua_fragment_mc, container, false);
        this.configureView(view);
        return view;
    }

    @CallSuper
    public void onViewCreated(@NonNull View view, final @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.configureView(view);
        this.messageListFragment.setPredicate(this.predicate);
        if (savedInstanceState != null && savedInstanceState.containsKey(STATE_ABS_LIST_VIEW)) {
            this.messageListFragment.getAbsListViewAsync(new MessageListFragment.OnListViewReadyCallback(){

                @Override
                public void onListViewReady(@NonNull AbsListView absListView) {
                    absListView.onRestoreInstanceState(savedInstanceState.getParcelable(MessageCenterFragment.STATE_ABS_LIST_VIEW));
                }
            });
        }
    }

    private void configureView(@NonNull View view) {
        if (this.getActivity() == null) {
            return;
        }
        if (this.isViewConfigured) {
            return;
        }
        this.isViewConfigured = true;
        if (view.findViewById(R.id.message_list_container) == null) {
            throw new RuntimeException("Content must have a place holder view whose id attribute is 'R.id.message_list_container'");
        }
        this.messageListFragment = new MessageListFragment();
        this.getChildFragmentManager().beginTransaction().replace(R.id.message_list_container, (Fragment)this.messageListFragment, "messageList").commit();
        if (view.findViewById(R.id.message_container) != null) {
            this.isTwoPane = true;
            LinearLayout layoutContainer = (LinearLayout)view.findViewById(R.id.container);
            TypedArray attributes = this.getActivity().getTheme().obtainStyledAttributes(null, R.styleable.MessageCenter, R.attr.messageCenterStyle, R.style.MessageCenter);
            if (attributes.hasValue(R.styleable.MessageCenter_messageCenterDividerColor)) {
                int color = attributes.getColor(R.styleable.MessageCenter_messageCenterDividerColor, -16777216);
                DrawableCompat.setTint((Drawable)layoutContainer.getDividerDrawable(), (int)color);
                DrawableCompat.setTintMode((Drawable)layoutContainer.getDividerDrawable(), (PorterDuff.Mode)PorterDuff.Mode.SRC);
            }
            attributes.recycle();
            if (this.currentMessageId != null) {
                this.messageListFragment.setCurrentMessage(this.currentMessageId);
            }
        } else {
            this.isTwoPane = false;
        }
        this.configureMessageListFragment(this.messageListFragment);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.isViewConfigured = false;
    }

    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        savedInstanceState.putString(STATE_CURRENT_MESSAGE_ID, this.currentMessageId);
        savedInstanceState.putInt(STATE_CURRENT_MESSAGE_POSITION, this.currentMessagePosition);
        savedInstanceState.putString(STATE_PENDING_MESSAGE_ID, this.pendingMessageId);
        if (this.messageListFragment != null && this.messageListFragment.getAbsListView() != null) {
            savedInstanceState.putParcelable(STATE_ABS_LIST_VIEW, this.messageListFragment.getAbsListView().onSaveInstanceState());
        }
        super.onSaveInstanceState(savedInstanceState);
    }

    protected void configureMessageListFragment(final @NonNull MessageListFragment messageListFragment) {
        messageListFragment.getAbsListViewAsync(new MessageListFragment.OnListViewReadyCallback(){

            @Override
            public void onListViewReady(@NonNull AbsListView absListView) {
                absListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        Message message = messageListFragment.getMessage(position);
                        if (message != null) {
                            MessageCenterFragment.this.showMessage(message.getMessageId());
                        }
                    }
                });
                absListView.setMultiChoiceModeListener((AbsListView.MultiChoiceModeListener)new DefaultMultiChoiceModeListener(messageListFragment));
                absListView.setChoiceMode(3);
                absListView.setSaveEnabled(false);
            }
        });
    }

    public void onResume() {
        super.onResume();
        if (this.isTwoPane) {
            MessageCenter.shared().getInbox().addListener(this.inboxListener);
        }
        this.updateCurrentMessage();
        if (this.pendingMessageId != null) {
            this.showMessage(this.pendingMessageId);
            this.pendingMessageId = null;
        }
    }

    public void onPause() {
        super.onPause();
        MessageCenter.shared().getInbox().removeListener(this.inboxListener);
    }

    @NonNull
    private List<Message> getMessages() {
        return MessageCenter.shared().getInbox().getMessages(this.predicate);
    }

    public void setMessageID(@Nullable String messageId) {
        if (this.isResumed()) {
            this.showMessage(messageId);
        } else {
            this.pendingMessageId = messageId;
        }
    }

    protected void showMessage(@Nullable String messageId) {
        if (this.getContext() == null) {
            return;
        }
        Message message = MessageCenter.shared().getInbox().getMessage(messageId);
        this.currentMessagePosition = message == null ? -1 : this.getMessages().indexOf(message);
        this.currentMessageId = messageId;
        if (this.messageListFragment == null) {
            return;
        }
        if (this.isTwoPane) {
            String tag;
            String string2 = tag = messageId == null ? "EMPTY_MESSAGE" : messageId;
            if (this.getChildFragmentManager().findFragmentByTag(tag) != null) {
                return;
            }
            Fragment fragment = messageId == null ? new NoMessageSelectedFragment() : MessageFragment.newInstance(messageId);
            this.getChildFragmentManager().beginTransaction().replace(R.id.message_container, fragment, tag).commit();
            this.messageListFragment.setCurrentMessage(messageId);
        } else if (messageId != null) {
            this.showMessageExternally(this.getContext(), messageId);
        }
    }

    protected void showMessageExternally(@NonNull Context context, @NonNull String messageId) {
        Intent intent = new Intent().setPackage(context.getPackageName()).addFlags(0x30000000).setData(Uri.fromParts((String)"message", (String)messageId, null));
        intent.setAction("com.urbanairship.VIEW_RICH_PUSH_MESSAGE");
        if (intent.resolveActivity(context.getPackageManager()) == null) {
            intent.setClass(context, MessageActivity.class);
        }
        context.startActivity(intent);
    }

    private void updateCurrentMessage() {
        Message message = MessageCenter.shared().getInbox().getMessage(this.currentMessageId);
        List<Message> messages = this.getMessages();
        if (this.isTwoPane && this.currentMessagePosition != -1 && !messages.contains(message)) {
            if (messages.size() == 0) {
                this.currentMessageId = null;
                this.currentMessagePosition = -1;
            } else {
                this.currentMessagePosition = Math.min(messages.size() - 1, this.currentMessagePosition);
                this.currentMessageId = messages.get(this.currentMessagePosition).getMessageId();
            }
            if (this.isTwoPane) {
                this.showMessage(this.currentMessageId);
            }
        }
    }

    public void setPredicate(@Nullable Predicate<Message> predicate) {
        this.predicate = predicate;
    }

    public static class NoMessageSelectedFragment
    extends Fragment {
        @NonNull
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            Context context = inflater.getContext();
            View view = inflater.inflate(R.layout.ua_fragment_no_message_selected, container, false);
            View emptyListView = view.findViewById(16908292);
            if (emptyListView instanceof TextView) {
                TypedArray attributes = context.getTheme().obtainStyledAttributes(null, R.styleable.MessageCenter, R.attr.messageCenterStyle, R.style.MessageCenter);
                TextView textView = (TextView)emptyListView;
                int textAppearance = attributes.getResourceId(R.styleable.MessageCenter_messageNotSelectedTextAppearance, 0);
                ViewUtils.applyTextStyle((Context)inflater.getContext(), (TextView)textView, (int)textAppearance);
                String text = attributes.getString(R.styleable.MessageCenter_messageNotSelectedText);
                textView.setText((CharSequence)text);
                attributes.recycle();
            }
            return view;
        }
    }
}

