/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import com.urbanairship.UALog;
import com.urbanairship.analytics.data.BatchedQueryHelper;
import com.urbanairship.messagecenter.MessageEntity;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Dao
public abstract class MessageDao {
    public void insert(MessageEntity message) {
        try {
            this.insertInternal(message);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to insert message!", (Object[])new Object[0]);
        }
    }

    public void insertMessages(List<MessageEntity> messages) {
        try {
            this.insertMessagesInternal(messages);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to insert messages!", (Object[])new Object[0]);
        }
    }

    public List<MessageEntity> getMessages() {
        try {
            return this.getMessagesInternal();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get messages!", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<String> getMessageIds() {
        try {
            return this.getMessageIdsInternal();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get message IDs!", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<MessageEntity> getLocallyReadMessages() {
        try {
            return this.getLocallyReadMessagesInternal();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get locally read messages!", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<MessageEntity> getLocallyDeletedMessages() {
        try {
            return this.getLocallyDeletedMessagesInternal();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to get locally deleted messages!", (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    public void markMessagesRead(List<String> messageIds) {
        try {
            this.markMessagesReadInternal(messageIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to mark messages as read!", (Object[])new Object[0]);
        }
    }

    public void markMessagesUnread(List<String> messageIds) {
        try {
            this.markMessagesUnreadInternal(messageIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to mark messages as unread!", (Object[])new Object[0]);
        }
    }

    public void markMessagesDeleted(List<String> messageIds) {
        try {
            this.markMessagesDeletedInternal(messageIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to mark messages as deleted!", (Object[])new Object[0]);
        }
    }

    public void markMessagesReadOrigin(List<String> messageIds) {
        try {
            this.markMessagesReadOriginInternal(messageIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to mark messages as read (origin)!", (Object[])new Object[0]);
        }
    }

    public void deleteMessages(List<String> messageIds) {
        try {
            this.deleteMessagesInternal(messageIds);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to delete messages!", (Object[])new Object[0]);
        }
    }

    public void deleteAllMessages() {
        try {
            this.deleteAllMessagesInternal();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to delete all messages!", (Object[])new Object[0]);
        }
    }

    public boolean messageExists(String messageId) {
        try {
            return this.messageExistsInternal(messageId);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Failed to check if message exists!", (Object[])new Object[0]);
            return false;
        }
    }

    @Insert(onConflict=1)
    protected abstract void insertInternal(MessageEntity var1);

    @Insert(onConflict=1)
    protected abstract void insertMessagesInternal(List<MessageEntity> var1);

    @Transaction
    @Query(value="SELECT * FROM richpush")
    protected abstract List<MessageEntity> getMessagesInternal();

    @Transaction
    @Query(value="SELECT message_id FROM richpush")
    protected abstract List<String> getMessageIdsInternal();

    @Transaction
    @Query(value="SELECT * FROM richpush WHERE unread = 0 AND unread <> unread_orig")
    protected abstract List<MessageEntity> getLocallyReadMessagesInternal();

    @Transaction
    @Query(value="SELECT * FROM richpush WHERE deleted = 1")
    protected abstract List<MessageEntity> getLocallyDeletedMessagesInternal();

    @Transaction
    @Query(value="UPDATE richpush SET unread = 0 WHERE message_id IN (:messageIds)")
    protected abstract void markMessagesReadInternal(List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET unread = 1 WHERE message_id IN (:messageIds)")
    protected abstract void markMessagesUnreadInternal(List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET deleted = 1 WHERE message_id IN (:messageIds)")
    protected abstract void markMessagesDeletedInternal(List<String> var1);

    @Transaction
    @Query(value="UPDATE richpush SET unread_orig = 0 WHERE message_id IN (:messageIds)")
    protected abstract void markMessagesReadOriginInternal(List<String> var1);

    @Transaction
    protected void deleteMessagesInternal(List<String> messageIds) {
        Consumer consumer = ids -> this.deleteMessagesBatchInternal((List<String>)ids);
        BatchedQueryHelper.runBatched(messageIds, (Consumer)consumer);
    }

    @Query(value="DELETE FROM richpush WHERE message_id IN (:messageIds)")
    protected abstract void deleteMessagesBatchInternal(List<String> var1);

    @Transaction
    @Query(value="DELETE FROM richpush")
    protected abstract void deleteAllMessagesInternal();

    @Query(value="SELECT EXISTS (SELECT 1 FROM richpush WHERE message_id = :id)")
    protected abstract boolean messageExistsInternal(String var1);
}

