/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import com.urbanairship.UALog;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.util.UAStringUtil;
import java.util.ArrayList;
import java.util.List;

@Entity(tableName="richpush", indices={@Index(value={"message_id"}, unique=true)})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MessageEntity {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="_id")
    protected int id;
    @ColumnInfo(name="message_id")
    public String messageId;
    @ColumnInfo(name="message_url")
    public String messageUrl;
    @ColumnInfo(name="message_body_url")
    public String messageBodyUrl;
    @ColumnInfo(name="message_read_url")
    public String messageReadUrl;
    public String title;
    public String extra;
    public boolean unread;
    @ColumnInfo(name="unread_orig")
    public boolean unreadOrig;
    public boolean deleted;
    public String timestamp;
    @ColumnInfo(name="raw_message_object")
    public String rawMessageObject;
    @ColumnInfo(name="expiration_timestamp")
    public String expirationTimestamp;

    public MessageEntity(String messageId, String messageUrl, String messageBodyUrl, String messageReadUrl, String title, String extra, boolean unread, boolean unreadOrig, boolean deleted, String timestamp, String rawMessageObject, String expirationTimestamp) {
        this.messageId = messageId;
        this.messageUrl = messageUrl;
        this.messageBodyUrl = messageBodyUrl;
        this.messageReadUrl = messageReadUrl;
        this.title = title;
        this.extra = extra;
        this.unread = unread;
        this.unreadOrig = unreadOrig;
        this.deleted = deleted;
        this.timestamp = timestamp;
        this.rawMessageObject = rawMessageObject;
        this.expirationTimestamp = expirationTimestamp;
    }

    @Nullable
    protected static MessageEntity createMessageFromPayload(@Nullable String messageId, @NonNull JsonValue messagePayload) {
        if (messagePayload == JsonValue.NULL || !messagePayload.isJsonMap()) {
            UALog.e((String)"MessageEntity - Unexpected message: %s", (Object[])new Object[]{messagePayload});
            return null;
        }
        JsonMap messageMap = messagePayload.optMap();
        if (UAStringUtil.isEmpty((String)messageMap.opt("message_id").getString())) {
            UALog.e((String)"MessageEntity - Message is missing an ID: %s", (Object[])new Object[]{messagePayload});
            return null;
        }
        return new MessageEntity(messageId != null ? messageId : messageMap.opt("message_id").getString(), messageMap.opt("message_url").getString(), messageMap.opt("message_body_url").getString(), messageMap.opt("message_read_url").getString(), messageMap.opt("title").getString(), messageMap.opt("extra").getString(), messageMap.opt("unread").getBoolean(true), messageMap.opt("unread").getBoolean(true), false, messageMap.opt("message_sent").getString(), messageMap.toString(), messageMap.containsKey("message_expiry") ? messageMap.opt("message_expiry").getString() : null);
    }

    @NonNull
    protected static List<MessageEntity> createMessagesFromPayload(@NonNull List<JsonValue> messagePayloads) {
        ArrayList<MessageEntity> messageEntities = new ArrayList<MessageEntity>();
        for (JsonValue messagePayload : messagePayloads) {
            MessageEntity messageEntity = MessageEntity.createMessageFromPayload(null, messagePayload);
            if (messageEntity == null) continue;
            messageEntities.add(messageEntity);
        }
        return messageEntities;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    protected JsonValue getMessageReporting() {
        try {
            JsonMap messageMap = JsonValue.parseString((String)this.rawMessageObject).getMap();
            if (messageMap != null) {
                return messageMap.get("message_reporting");
            }
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)"MessageEntity - Failed to parse Message reporting.", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected Message createMessageFromEntity(MessageEntity entity) {
        try {
            return Message.create(JsonValue.parseString((String)entity.rawMessageObject), entity.unread, entity.deleted);
        }
        catch (JsonException e) {
            UALog.e((String)"Failed to create Message from JSON", (Object[])new Object[0]);
            return null;
        }
    }
}

