/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DrawableRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.urbanairship.Cancelable;
import com.urbanairship.Predicate;
import com.urbanairship.messagecenter.Inbox;
import com.urbanairship.messagecenter.InboxListener;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.messagecenter.MessageItemView;
import com.urbanairship.messagecenter.MessageViewAdapter;
import com.urbanairship.messagecenter.R;
import com.urbanairship.util.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public class MessageListFragment
extends Fragment {
    private SwipeRefreshLayout refreshLayout;
    private AbsListView absListView;
    private Inbox inbox;
    private MessageViewAdapter adapter;
    private Cancelable fetchMessagesOperation;
    private String currentMessageId;
    private Predicate<Message> predicate;
    private final List<OnListViewReadyCallback> pendingCallbacks = new ArrayList<OnListViewReadyCallback>();
    @DrawableRes
    private int placeHolder = R.drawable.ua_ic_image_placeholder;
    private final InboxListener inboxListener = this::updateAdapterMessages;

    private List<Message> getMessages() {
        return this.inbox.getMessages(this.predicate);
    }

    private void updateAdapterMessages() {
        if (this.getAdapter() != null) {
            this.getAdapter().set(this.getMessages());
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.inbox = MessageCenter.shared().getInbox();
        this.updateAdapterMessages();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.ua_fragment_message_list, container, false);
        this.ensureList(view);
        if (this.getAbsListView() == null) {
            return view;
        }
        this.getAbsListView().setOnItemClickListener((parent, view1, position, id2) -> {
            Message message = this.getMessage(position);
            if (message != null) {
                MessageCenter.shared().showMessageCenter(message.getMessageId());
            }
        });
        View emptyListView = view.findViewById(16908292);
        if (emptyListView != null) {
            this.absListView.setEmptyView(emptyListView);
        }
        return view;
    }

    @CallSuper
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureList(view);
        for (OnListViewReadyCallback callback : new ArrayList<OnListViewReadyCallback>(this.pendingCallbacks)) {
            callback.onListViewReady(this.absListView);
        }
        this.pendingCallbacks.clear();
    }

    private void ensureList(@NonNull View view) {
        if (this.getContext() == null) {
            return;
        }
        if (this.absListView != null) {
            return;
        }
        this.absListView = view instanceof AbsListView ? (AbsListView)view : (AbsListView)view.findViewById(16908298);
        if (this.absListView == null) {
            throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
        }
        if (this.getAdapter() != null) {
            this.absListView.setAdapter((ListAdapter)this.getAdapter());
        }
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_container);
        if (this.refreshLayout != null) {
            this.refreshLayout.setOnRefreshListener(this::onRefreshMessages);
        }
        View emptyListView = view.findViewById(16908292);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(null, R.styleable.MessageCenter, R.attr.messageCenterStyle, R.style.MessageCenter);
        if (emptyListView instanceof TextView) {
            TextView textView = (TextView)emptyListView;
            int textAppearance = attributes.getResourceId(R.styleable.MessageCenter_messageCenterEmptyMessageTextAppearance, -1);
            ViewUtils.applyTextStyle((Context)this.getContext(), (TextView)textView, (int)textAppearance);
            String text = attributes.getString(R.styleable.MessageCenter_messageCenterEmptyMessageText);
            textView.setText((CharSequence)text);
        }
        if (this.absListView instanceof ListView) {
            ListView listView = (ListView)this.absListView;
            if (attributes.hasValue(R.styleable.MessageCenter_messageCenterDividerColor) && listView.getDivider() != null) {
                int color = attributes.getColor(R.styleable.MessageCenter_messageCenterDividerColor, -16777216);
                DrawableCompat.setTint((Drawable)listView.getDivider(), (int)color);
                DrawableCompat.setTintMode((Drawable)listView.getDivider(), (PorterDuff.Mode)PorterDuff.Mode.SRC);
            }
        }
        this.placeHolder = attributes.getResourceId(R.styleable.MessageCenter_messageCenterItemIconPlaceholder, this.placeHolder);
        attributes.recycle();
    }

    @NonNull
    protected MessageViewAdapter createMessageViewAdapter(@NonNull Context context) {
        final ArrayList selectedMessageIds = new ArrayList();
        return new MessageViewAdapter(context, R.layout.ua_item_mc){

            @Override
            protected void bindView(@NonNull View view, @NonNull Message message, int position) {
                if (view instanceof MessageItemView) {
                    MessageItemView itemView = (MessageItemView)view;
                    itemView.setSelectionListener(v -> this.setSelection(message.getMessageId(), position));
                    itemView.updateMessage(message, MessageListFragment.this.placeHolder, this.isSelected(message));
                    itemView.setHighlighted(message.getMessageId().equals(MessageListFragment.this.currentMessageId));
                }
            }

            private void setSelection(String messageId, int position) {
                AbsListView list = MessageListFragment.this.getAbsListView();
                if (list == null) {
                    return;
                }
                boolean isChecked = !list.isItemChecked(position);
                list.setItemChecked(position, isChecked);
                if (isChecked) {
                    selectedMessageIds.add(messageId);
                } else {
                    selectedMessageIds.remove(messageId);
                }
            }

            private boolean isSelected(@NonNull Message message) {
                return selectedMessageIds.contains(message.getMessageId());
            }
        };
    }

    public void onResume() {
        super.onResume();
        this.inbox.addListener(this.inboxListener);
        this.updateAdapterMessages();
        this.inbox.fetchMessages();
        if (this.getAbsListView() != null) {
            this.getAbsListView().invalidate();
        }
    }

    public void onPause() {
        super.onPause();
        this.inbox.removeListener(this.inboxListener);
        if (this.fetchMessagesOperation != null) {
            this.fetchMessagesOperation.cancel();
        }
    }

    private void onRefreshMessages() {
        if (this.fetchMessagesOperation != null) {
            this.fetchMessagesOperation.cancel();
        }
        this.fetchMessagesOperation = this.inbox.fetchMessages(success -> {
            if (this.refreshLayout != null) {
                this.refreshLayout.setRefreshing(false);
            }
        });
        if (this.refreshLayout != null) {
            this.refreshLayout.setRefreshing(true);
        }
    }

    @Nullable
    public AbsListView getAbsListView() {
        return this.absListView;
    }

    @MainThread
    public void getAbsListViewAsync(@NonNull OnListViewReadyCallback callback) {
        if (this.absListView != null) {
            callback.onListViewReady(this.absListView);
        } else {
            this.pendingCallbacks.add(callback);
        }
    }

    @Nullable
    public Message getMessage(int position) {
        if (this.adapter != null && this.adapter.getCount() > position) {
            return (Message)this.adapter.getItem(position);
        }
        return null;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.absListView.setChoiceMode(0);
        this.absListView = null;
        this.refreshLayout = null;
    }

    public void onDestroy() {
        super.onDestroy();
        this.pendingCallbacks.clear();
    }

    @Nullable
    public MessageViewAdapter getAdapter() {
        if (this.adapter == null) {
            if (this.getContext() == null) {
                return null;
            }
            this.adapter = this.createMessageViewAdapter(this.getContext());
        }
        return this.adapter;
    }

    void setCurrentMessage(@Nullable String messageId) {
        if (this.currentMessageId == null && messageId == null) {
            return;
        }
        if (this.currentMessageId != null && this.currentMessageId.equals(messageId)) {
            return;
        }
        this.currentMessageId = messageId;
        if (this.getAdapter() != null) {
            this.getAdapter().notifyDataSetChanged();
        }
    }

    void setPredicate(Predicate<Message> predicate) {
        this.predicate = predicate;
        if (this.getAdapter() != null) {
            this.updateAdapterMessages();
        }
    }

    public static interface OnListViewReadyCallback {
        public void onListViewReady(@NonNull AbsListView var1);
    }
}

