/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.messagecenter.webkit;

import android.os.Bundle;
import android.webkit.WebView;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.actions.ActionRunRequest;
import com.urbanairship.javascript.JavaScriptEnvironment;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.messagecenter.Message;
import com.urbanairship.messagecenter.MessageCenter;
import com.urbanairship.webkit.AirshipWebViewClient;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class MessageWebViewClient
extends AirshipWebViewClient {
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ", Locale.US);

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected ActionRunRequest extendActionRequest(@NonNull ActionRunRequest request, @NonNull WebView webView) {
        Bundle metadata = new Bundle();
        Message message = this.getMessage(webView);
        if (message != null) {
            metadata.putString("com.urbanairship.RICH_PUSH_ID_METADATA", message.getMessageId());
        }
        request.setMetadata(metadata);
        return request;
    }

    @CallSuper
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected JavaScriptEnvironment.Builder extendJavascriptEnvironment(@NonNull JavaScriptEnvironment.Builder builder, @NonNull WebView webView) {
        Message message = this.getMessage(webView);
        JsonMap extras = JsonMap.EMPTY_MAP;
        if (message != null) {
            extras = JsonValue.wrapOpt(message.getExtrasMap()).optMap();
        }
        return super.extendJavascriptEnvironment(builder, webView).addGetter("getMessageSentDateMS", message != null ? message.getSentDateMS() : -1L).addGetter("getMessageId", message != null ? message.getMessageId() : null).addGetter("getMessageTitle", message != null ? message.getTitle() : null).addGetter("getMessageSentDate", message != null ? DATE_FORMATTER.format(message.getSentDate()) : null).addGetter("getUserId", MessageCenter.shared().getUser().getId()).addGetter("getMessageExtras", (JsonSerializable)extras);
    }

    @MainThread
    @Nullable
    private Message getMessage(@NonNull WebView webView) {
        return MessageCenter.shared().getInbox().getMessageByUrl(webView.getUrl());
    }

    static {
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

