/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.customevents.model.CustomEventChannelType;

public class CustomEventUser {
    private final CustomEventChannelType channelType;
    private final String channel;

    private CustomEventUser(Builder builder) {
        this.channelType = builder.channelType;
        this.channel = builder.channel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CustomEventChannelType getChannelType() {
        return this.channelType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventUser that = (CustomEventUser)o;
        return this.channelType == that.channelType && Objects.equal((Object)this.channel, (Object)that.channel);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelType, this.channel});
    }

    public String getChannel() {
        return this.channel;
    }

    public static class Builder {
        private String channel = null;
        private CustomEventChannelType channelType = null;

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setCustomEventChannelType(CustomEventChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        public CustomEventUser build() {
            Preconditions.checkNotNull((Object)((Object)this.channelType), (Object)"'channelType' must not be null");
            Preconditions.checkNotNull((Object)this.channel, (Object)"'channel' must not be null");
            return new CustomEventUser(this);
        }
    }
}

