/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public final class ExperimentResponse {
    private final boolean ok;
    private final Optional<String> operationId;
    private final Optional<String> experimentId;
    private final Optional<String> pushId;

    private ExperimentResponse(boolean ok, String operationId, String experimentId, String pushId) {
        this.ok = ok;
        this.operationId = Optional.fromNullable((Object)operationId);
        this.experimentId = Optional.fromNullable((Object)experimentId);
        this.pushId = Optional.fromNullable((Object)pushId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public Optional<String> getExperimentId() {
        return this.experimentId;
    }

    public Optional<String> getPushId() {
        return this.pushId;
    }

    public String toString() {
        return "ExperimentResponse{ok=" + this.ok + ", operationId=" + this.operationId + ", experimentId=" + this.experimentId + ", pushId=" + this.pushId + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operationId, this.pushId, this.ok, this.experimentId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExperimentResponse other = (ExperimentResponse)obj;
        return Objects.equal(this.operationId, other.operationId) && Objects.equal(this.pushId, other.pushId) && Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.experimentId, other.experimentId);
    }

    public static class Builder {
        private String operationId = null;
        private String pushId = null;
        private boolean ok = false;
        private String experimentId = null;

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setExperimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public Builder setPushId(String pushId) {
            this.pushId = pushId;
            return this;
        }

        public ExperimentResponse build() {
            return new ExperimentResponse(this.ok, this.operationId, this.experimentId, this.pushId);
        }
    }
}

