/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ChannelView;

public class NamedUserView {
    private final String namedUserId;
    private final ImmutableMap<String, ImmutableSet<String>> namedUserTags;
    private final ImmutableSet<ChannelView> channelViews;

    public static Builder newBuilder() {
        return new Builder();
    }

    private NamedUserView(String namedUserId, ImmutableMap<String, ImmutableSet<String>> namedUserTags, ImmutableSet<ChannelView> channelViews) {
        this.namedUserId = namedUserId;
        this.namedUserTags = namedUserTags;
        this.channelViews = channelViews;
    }

    public String getNamedUserId() {
        return this.namedUserId;
    }

    public ImmutableMap<String, ImmutableSet<String>> getNamedUserTags() {
        return this.namedUserTags;
    }

    public ImmutableSet<ChannelView> getChannelViews() {
        return this.channelViews;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedUserView that = (NamedUserView)o;
        if (!this.channelViews.equals(that.channelViews)) {
            return false;
        }
        if (!this.namedUserId.equals(that.namedUserId)) {
            return false;
        }
        return this.namedUserTags.equals(that.namedUserTags);
    }

    public int hashCode() {
        int result = this.namedUserId.hashCode();
        result = 31 * result + this.namedUserTags.hashCode();
        result = 31 * result + this.channelViews.hashCode();
        return result;
    }

    public String toString() {
        return "NamedUserView{namedUserId='" + this.namedUserId + '\'' + ", namedUserTags=" + this.namedUserTags + ", channelViews=" + this.channelViews + '}';
    }

    public static final class Builder {
        private String namedUserId = null;
        private ImmutableMap<String, ImmutableSet<String>> namedUserTags = null;
        private ImmutableSet<ChannelView> channelViews = null;

        private Builder() {
        }

        public Builder setNamedUserId(String namedUserId) {
            this.namedUserId = namedUserId;
            return this;
        }

        public Builder setNamedUserTags(ImmutableMap<String, ImmutableSet<String>> namedUserTags) {
            this.namedUserTags = namedUserTags;
            return this;
        }

        public Builder setChannelViews(ImmutableSet<ChannelView> channelViews) {
            this.channelViews = channelViews;
            return this;
        }

        public NamedUserView build() {
            return new NamedUserView(this.namedUserId, this.namedUserTags, this.channelViews);
        }
    }
}

