/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;

public enum DeviceType {
    IOS("ios"),
    WNS("wns"),
    ANDROID("android"),
    AMAZON("amazon"),
    WEB("web");

    private final String identifier;
    public static final Function<String, Optional<DeviceType>> fromIdentifierFunction;

    public static DeviceType first() {
        return IOS;
    }

    public static DeviceType last() {
        return WEB;
    }

    private DeviceType(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static Optional<DeviceType> find(String id) {
        return (Optional)fromIdentifierFunction.apply((Object)id);
    }

    static {
        fromIdentifierFunction = new Function<String, Optional<DeviceType>>(){

            public Optional<DeviceType> apply(String identifier) {
                for (DeviceType deviceType : DeviceType.values()) {
                    if (!deviceType.getIdentifier().equals(identifier)) continue;
                    return Optional.of((Object)((Object)deviceType));
                }
                return Optional.absent();
            }
        };
    }
}

