/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.android.Style;

public class BigTextStyle
implements Style<String> {
    private final String content;
    private final Optional<String> title;
    private final Optional<String> summary;

    private BigTextStyle(Builder builder) {
        this.content = builder.content;
        this.title = Optional.of((Object)builder.title);
        this.summary = Optional.of((Object)builder.summary);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Style.Type getType() {
        return Style.Type.BIG_TEXT;
    }

    @Override
    public Optional<String> getTitle() {
        return this.title;
    }

    @Override
    public Optional<String> getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigTextStyle that = (BigTextStyle)o;
        if (!this.content.equals(that.content)) {
            return false;
        }
        if (!this.summary.equals(that.summary)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public String toString() {
        return "BigTextStyle{content=" + this.content + ", title=" + this.title + ", summary=" + this.summary + '}';
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.summary.hashCode();
        return result;
    }

    public static class Builder {
        private String content = null;
        private String title = null;
        private String summary = null;

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public BigTextStyle build() {
            Preconditions.checkNotNull((Object)this.content, (Object)"The content field cannot be null.");
            return new BigTextStyle(this);
        }
    }
}

