/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.reports.model.PlatformStats;

public class PlatformStatsResponse {
    private final Optional<String> nextPage;
    private final Optional<ImmutableList<PlatformStats>> platformStatsObjects;

    private PlatformStatsResponse() {
        this(null, null);
    }

    private PlatformStatsResponse(Optional<String> nextPage, Optional<ImmutableList<PlatformStats>> platformStatsObjects) {
        this.nextPage = nextPage;
        this.platformStatsObjects = platformStatsObjects;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<ImmutableList<PlatformStats>> getPlatformStatsObjects() {
        return this.platformStatsObjects;
    }

    public String toString() {
        return "PlatformStatsResponse{nextPage=" + this.nextPage + "platformStatsObjects=" + this.platformStatsObjects + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.platformStatsObjects});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformStatsResponse other = (PlatformStatsResponse)obj;
        return Objects.equal(this.platformStatsObjects, other.platformStatsObjects);
    }

    public static class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<PlatformStats> platformStatsObjects = ImmutableList.builder();

        private Builder() {
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder addPlatformStatsObject(PlatformStats value) {
            this.platformStatsObjects.add((Object)value);
            return this;
        }

        public Builder addPlatformStatsObjects(Iterable<? extends PlatformStats> value) {
            this.platformStatsObjects.addAll(value);
            return this;
        }

        public PlatformStatsResponse build() {
            return new PlatformStatsResponse(Optional.fromNullable((Object)this.nextPage), Optional.fromNullable((Object)this.platformStatsObjects.build()));
        }
    }
}

