/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.segments.model.SegmentListingResponse;
import com.urbanairship.api.segments.parse.SegmentObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class SegmentListingRequest
implements Request<SegmentListingResponse> {
    private static final String API_SEGMENTS_PATH = "/api/segments/";
    private final String path;

    private SegmentListingRequest(String path) {
        this.path = path;
    }

    public static SegmentListingRequest newRequest() {
        return new SegmentListingRequest(API_SEGMENTS_PATH);
    }

    public static SegmentListingRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new SegmentListingRequest(nextPage.getPath() + "?" + nextPage.getQuery());
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SegmentListingResponse> getResponseParser() {
        return new ResponseParser<SegmentListingResponse>(){

            @Override
            public SegmentListingResponse parse(String response) throws IOException {
                return (SegmentListingResponse)SegmentObjectMapper.getInstance().readValue(response, SegmentListingResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

