/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInput;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gwtorm.server.StandardKeyEncoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public interface Changes {
    public ChangeApi id(int var1) throws RestApiException;

    public ChangeApi id(String var1) throws RestApiException;

    public ChangeApi id(String var1, String var2, String var3) throws RestApiException;

    public ChangeApi id(String var1, int var2) throws RestApiException;

    public ChangeApi create(ChangeInput var1) throws RestApiException;

    public ChangeInfo createAsInfo(ChangeInput var1) throws RestApiException;

    public QueryRequest query();

    public QueryRequest query(String var1);

    public static class NotImplemented
    implements Changes {
        @Override
        public ChangeApi id(int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String triplet) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String project, String branch, String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String project, int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi create(ChangeInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo createAsInfo(ChangeInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query(String query) {
            throw new NotImplementedException();
        }
    }

    public static abstract class QueryRequest {
        private String query;
        private int limit;
        private int start;
        private String sortkey;
        private boolean isNoLimit;
        private Set<ListChangesOption> options = EnumSet.noneOf(ListChangesOption.class);
        private ListMultimap<String, String> pluginOptions = ArrayListMultimap.create();

        public abstract List<ChangeInfo> get() throws RestApiException;

        public QueryRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryRequest encode() {
            this.query = StandardKeyEncoder.encode(this.query);
            return this;
        }

        public QueryRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest withNoLimit() {
            this.isNoLimit = true;
            return this;
        }

        public QueryRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public QueryRequest withSortkey(String sortkey) {
            this.sortkey = sortkey;
            return this;
        }

        public QueryRequest withOption(ListChangesOption options) {
            this.options.add(options);
            return this;
        }

        public QueryRequest withOptions(ListChangesOption ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public QueryRequest withOptions(Set<ListChangesOption> options) {
            this.options = options;
            return this;
        }

        public QueryRequest withPluginOption(String name, String value) {
            this.pluginOptions.put((Object)name, (Object)value);
            return this;
        }

        public QueryRequest withPluginOptions(ListMultimap<String, String> options) {
            this.pluginOptions = ArrayListMultimap.create(options);
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean getNoLimit() {
            return this.isNoLimit;
        }

        public int getStart() {
            return this.start;
        }

        public String getSortkey() {
            return this.sortkey;
        }

        public Set<ListChangesOption> getOptions() {
            return this.options;
        }

        public ListMultimap<String, String> getPluginOptions() {
            return this.pluginOptions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('{').append(this.query);
            if (this.limit != 0) {
                sb.append(", limit=").append(this.limit);
            }
            if (this.start != 0) {
                sb.append(", start=").append(this.start);
            }
            if (!this.options.isEmpty()) {
                sb.append("options=").append(this.options);
            }
            sb.append('}');
            if (this.isNoLimit) {
                sb.append(" --no-limit");
            }
            return sb.toString();
        }
    }
}

